/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.PAPTransaction;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusServerProxy;
import org.rvpf.pap.modbus.message.ErrorResponse;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.transport.ExceptionCode;
import org.rvpf.pap.modbus.transport.Transport;

public interface Transaction {
    public static final short[] NO_VALUES = new short[0];

    public static abstract class Response
    implements PAPTransaction.Response {
        public static final Response NULL = new Response(new Prefix(0), Request.NULL){

            @Override
            public void write(Transport transport) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void read(Transport transport) throws IOException, FormatException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLength() {
                throw new UnsupportedOperationException();
            }
        };
        private final Prefix _prefix;
        private final Request _request;

        protected Response(@Nonnull Request request) {
            this(request.getPrefix().copy(), request);
        }

        protected Response(@Nonnull Prefix prefix, @Nonnull Request request) {
            this._prefix = (Prefix)Require.notNull((Object)prefix);
            this._request = (Request)Require.notNull((Object)request);
        }

        @CheckReturnValue
        public byte getFunctionCode() {
            Request request = (Request)Require.notNull((Object)this.getRequest());
            return request.getFunctionCode();
        }

        @CheckReturnValue
        public abstract int getLength();

        public final String getName() {
            Class<?> enclosingClass = this.getClass().getEnclosingClass();
            return enclosingClass != null ? enclosingClass.getSimpleName() : this.getClass().getSimpleName();
        }

        public final Prefix getPrefix() {
            return this._prefix;
        }

        @Nonnull
        @CheckReturnValue
        public Request getRequest() {
            return this._request;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        public abstract void read(@Nonnull Transport var1) throws IOException, FormatException;

        public abstract void write(@Nonnull Transport var1) throws IOException;

        protected static void readSuffix(@Nonnull Transport transport) throws IOException, FormatException {
            if (!transport.receiveSuffix()) {
                throw new FormatException(ModbusMessages.BAD_TRANSPORT_SUFFIX, new Object[0]);
            }
        }

        protected static final void writeSuffix(@Nonnull Transport transport) throws IOException {
            transport.sendSuffix();
        }

        protected void expectedBytes(int bytes) throws FormatException {
            if (!this.getPrefix().checkDataLength(bytes)) {
                throw new FormatException(ModbusMessages.MESSAGE_LENGTH_MBAP, new Object[0]);
            }
        }

        protected final void write(int length, @Nonnull Transport transport) throws IOException {
            this._prefix.saveDataLength(length);
            transport.sendPrefix(this._prefix);
            transport.sendByte(this.getFunctionCode());
        }
    }

    public static abstract class Request
    implements PAPTransaction.Request {
        public static final Request NULL = new Request(){

            @Override
            public void write(Transport transport) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Request read(Transport transport) throws IOException, FormatException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLength() {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte getFunctionCode() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Response createResponse(short[] values) {
                throw new UnsupportedOperationException();
            }
        };
        private byte _exceptionCode;
        private Prefix _prefix;
        private volatile int _retries;
        private volatile ModbusServerProxy _serverProxy;
        private volatile State _state;

        protected Request() {
            this._state = State.INACTIVE;
        }

        protected Request(@Nonnull Prefix prefix) {
            this._state = State.ACTIVE;
            this._prefix = prefix;
        }

        @Nonnull
        @CheckReturnValue
        public abstract Response createResponse(@Nonnull short[] var1);

        @Nonnull
        @CheckReturnValue
        public final ErrorResponse errorResponse() {
            return new ErrorResponse(this);
        }

        @CheckReturnValue
        public final byte getExceptionCode() {
            return this._exceptionCode;
        }

        @CheckReturnValue
        public abstract byte getFunctionCode();

        @CheckReturnValue
        public abstract int getLength();

        @Nonnull
        @CheckReturnValue
        public final String getName() {
            return this.getClass().getEnclosingClass().getSimpleName();
        }

        @Nonnull
        @CheckReturnValue
        public final Prefix getPrefix() {
            return (Prefix)Require.notNull((Object)this._prefix);
        }

        @CheckReturnValue
        public int getReadAddress() {
            throw new UnsupportedOperationException();
        }

        @CheckReturnValue
        public int getReadQuantity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<? extends PAPTransaction.Response> getResponse() throws InterruptedException, ConnectFailedException {
            return this.getServerProxy().getResponse(this);
        }

        @CheckReturnValue
        public final int getRetries() {
            return this._retries;
        }

        @Nonnull
        @CheckReturnValue
        public final ModbusServerProxy getServerProxy() {
            return (ModbusServerProxy)Require.notNull((Object)this._serverProxy);
        }

        @Nonnull
        @CheckReturnValue
        public DateTime getStamp() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        @CheckReturnValue
        public final State getState() {
            return this._state;
        }

        @CheckReturnValue
        public int getWriteAddress() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        @CheckReturnValue
        public short[] getWriteValues() {
            throw new UnsupportedOperationException();
        }

        @CheckReturnValue
        public final boolean hasBeenAnswered() {
            return this._state == State.ANSWERED;
        }

        @CheckReturnValue
        public final boolean hasFailed() {
            return this._state == State.FAILED;
        }

        @CheckReturnValue
        public final boolean isValid() {
            return this._exceptionCode == 0;
        }

        @Nonnull
        public abstract Request read(@Nonnull Transport var1) throws IOException, FormatException;

        public final void setExceptionCode(@Nonnull ExceptionCode exceptionCode) {
            this._exceptionCode = exceptionCode.getCodeByte();
        }

        public final void setServerProxy(@Nonnull ModbusServerProxy serverProxy) {
            this._serverProxy = serverProxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setState(@Nonnull State state) {
            this._state = state;
            Request request = this;
            synchronized (request) {
                this.notifyAll();
            }
        }

        @CheckReturnValue
        public boolean updateRetries() {
            Require.equal((Object)((Object)State.FAILED), (Object)((Object)this.getState()));
            int retries = this._retries;
            if (retries >= this.getServerProxy().getRequestRetries()) {
                return false;
            }
            this._retries = retries + 1;
            return true;
        }

        @Override
        public final boolean waitForResponse() throws InterruptedException, ConnectFailedException {
            return this.getServerProxy().waitForResponse(this);
        }

        public abstract void write(@Nonnull Transport var1) throws IOException;

        protected static void readSuffix(@Nonnull Transport transport) throws IOException, FormatException {
            if (!transport.receiveSuffix()) {
                throw new FormatException(ModbusMessages.BAD_TRANSPORT_SUFFIX, new Object[0]);
            }
        }

        protected static void writeSuffix(@Nonnull Transport transport) throws IOException {
            transport.sendSuffix();
        }

        protected final void expectedBytes(int bytes) throws FormatException {
            if (!this.getPrefix().checkDataLength(bytes)) {
                throw new FormatException(ModbusMessages.MESSAGE_LENGTH_MBAP, new Object[0]);
            }
        }

        protected final void write(int length, @Nonnull Transport transport) throws IOException {
            if (this._prefix == null) {
                this._prefix = transport.newPrefix();
            }
            this._prefix.saveDataLength(length);
            transport.sendPrefix(this._prefix);
            transport.sendByte(this.getFunctionCode());
        }
    }

    public static final class FormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FormatException(@Nonnull Messages.Entry entry, Object ... params) {
            super(Message.format((Messages.Entry)entry, (Object[])params));
        }
    }

    public static enum State {
        INACTIVE,
        ACTIVE,
        QUEUED,
        SENT,
        ANSWERED,
        FAILED;

    }
}

