/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.transport.Transport;

public interface WriteMultipleRegisters {
    public static final short FUNCTION_CODE = 16;
    public static final short MAXIMUM_QUANTITY = 123;

    public static final class Response
    extends WriteTransaction.Response {
        public Response(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
            super(prefix, (WriteTransaction.Request)request);
        }

        Response(@Nonnull Request request) {
            super(request);
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public void read(Transport transport) throws IOException, Transaction.FormatException {
            int address = (transport.receiveShort() & 0xFFFF) + 1;
            short quantity = transport.receiveShort();
            if (address != this.getRequest().getAddress()) {
                throw new Transaction.FormatException(ModbusMessages.STARTING_ADDRESS_MATCH, new Object[0]);
            }
            if (quantity != this.getRequest().getValues().length) {
                throw new Transaction.FormatException(ModbusMessages.QUANTITY_REGISTERS_MATCH, new Object[0]);
            }
            Response.readSuffix(transport);
        }

        @Override
        public void write(Transport transport) throws IOException {
            this.write(this.getLength(), transport);
            transport.sendShort(this.getRequest().getAddress() - 1);
            transport.sendShort(this.getRequest().getValues().length);
            Response.writeSuffix(transport);
        }
    }

    public static final class Request
    extends WriteTransaction.Request {
        public Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public Request(int startingAddress, @Nonnull short[] registerValues) {
            int quantity = registerValues.length;
            if (quantity < 1 || 123 < quantity) {
                throw new IllegalArgumentException();
            }
            this.setAddress(startingAddress);
            this.setValues(registerValues);
        }

        @Override
        public Transaction.Response createResponse(short[] values) {
            Require.equal((long)0L, (long)values.length);
            return this.isValid() ? new Response(this) : this.errorResponse();
        }

        @Override
        public byte getFunctionCode() {
            return 16;
        }

        @Override
        public int getLength() {
            return 5 + this.getValues().length * 2;
        }

        @Override
        public Request read(Transport transport) throws IOException, Transaction.FormatException {
            this.setAddress(transport.receiveShort() + 1);
            int quantity = transport.receiveShort();
            int byteCount = transport.receiveByte() & 0xFF;
            if (byteCount != quantity * 2) {
                throw new Transaction.FormatException(ModbusMessages.BYTE_COUNT_REGISTERS, byteCount, (short)quantity);
            }
            if (!this.getPrefix().checkDataLength(5 + byteCount)) {
                throw new Transaction.FormatException(ModbusMessages.MESSAGE_LENGTH_MBAP, new Object[0]);
            }
            short[] values = new short[quantity];
            for (int i = 0; i < quantity; ++i) {
                values[i] = transport.receiveShort();
            }
            this.setValues(values);
            Request.readSuffix(transport);
            return this;
        }

        @Override
        public void write(Transport transport) throws IOException {
            short[] values = this.getValues();
            this.write(5 + values.length * 2, transport);
            transport.sendShort(this.getAddress() - 1);
            transport.sendShort(values.length);
            transport.sendByte(values.length * 2);
            for (short value : values) {
                transport.sendShort(value);
            }
            Request.writeSuffix(transport);
        }
    }
}

