/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.transport.Transport;

public interface WriteReadMultipleRegisters {
    public static final short FUNCTION_CODE = 23;
    public static final short MAXIMUM_READ_QUANTITY = 125;
    public static final short MAXIMUM_WRITE_QUANTITY = 121;

    public static final class Response
    extends ReadTransaction.Response {
        public Response(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
            super(prefix, (ReadTransaction.Request)request);
        }

        Response(@Nonnull Request request) {
            super(request);
        }

        @Override
        public int getLength() {
            return 1 + this.getValues().length * 2;
        }

        @Override
        public void read(Transport transport) throws IOException, Transaction.FormatException {
            int quantity = this.getRequest().getQuantity();
            int byteCount = transport.receiveByte() & 0xFF;
            if (byteCount != quantity * 2) {
                throw new Transaction.FormatException(ModbusMessages.BYTE_COUNT_REGISTERS, byteCount, quantity);
            }
            this.expectedBytes(1 + byteCount);
            short[] values = new short[quantity];
            for (int i = 0; i < quantity; ++i) {
                values[i] = transport.receiveShort();
            }
            this.setValues(values);
            Response.readSuffix(transport);
        }

        @Override
        public void write(Transport transport) throws IOException {
            short[] values = this.getValues();
            this.write(1 + values.length * 2, transport);
            transport.sendByte(values.length * 2);
            for (short value : values) {
                transport.sendShort(value);
            }
            Response.writeSuffix(transport);
        }
    }

    public static final class Request
    extends ReadTransaction.Request {
        private int _address;
        private final DateTime _stamp = DateTime.now();
        private short[] _values;

        public Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public Request(int writeStartingAddress, @Nonnull short[] writeValues, int readStartingAddress, int readQuantity) {
            int writeQuantity = writeValues.length;
            if (writeQuantity < 1 || 121 < writeQuantity) {
                throw new IllegalArgumentException();
            }
            if (readQuantity < 1 || 125 < readQuantity) {
                throw new IllegalArgumentException();
            }
            this._setWriteAddress(writeStartingAddress);
            this._setWriteValues(writeValues);
            this._setReadAddress(readStartingAddress);
            this._setReadQuantity(readQuantity);
        }

        @Override
        public Transaction.Response createResponse(@Nonnull short[] values) {
            return this.initResponse(new Response(this), values);
        }

        @Override
        public byte getFunctionCode() {
            return 23;
        }

        @Override
        public int getLength() {
            return 9 + this.getWriteValues().length * 2;
        }

        @Override
        public int getReadAddress() {
            return this.getAddress();
        }

        @Override
        public int getReadQuantity() {
            return this.getQuantity();
        }

        @Override
        public DateTime getStamp() {
            return this._stamp;
        }

        @Override
        public int getWriteAddress() {
            return this._address;
        }

        @Override
        public short[] getWriteValues() {
            return this._values != null ? this._values : Transaction.NO_VALUES;
        }

        @Override
        public Request read(Transport transport) throws IOException, Transaction.FormatException {
            this._setReadAddress(transport.receiveShort() + 1);
            this._setReadQuantity(transport.receiveShort());
            this._setWriteAddress(transport.receiveShort() + 1);
            int writeQuantity = transport.receiveShort();
            int writeByteCount = transport.receiveByte() & 0xFF;
            if (writeByteCount != writeQuantity * 2) {
                throw new Transaction.FormatException(ModbusMessages.BYTE_COUNT_REGISTERS, writeByteCount, (short)writeQuantity);
            }
            if (!this.getPrefix().checkDataLength(9 + writeByteCount)) {
                throw new Transaction.FormatException(ModbusMessages.MESSAGE_LENGTH_MBAP, new Object[0]);
            }
            short[] writeValues = new short[writeQuantity];
            for (int i = 0; i < writeQuantity; ++i) {
                writeValues[i] = transport.receiveShort();
            }
            this._setWriteValues(writeValues);
            Request.readSuffix(transport);
            return this;
        }

        @Override
        public void write(Transport transport) throws IOException {
            short[] writeValues = this.getWriteValues();
            this.write(9 + writeValues.length * 2, transport);
            transport.sendShort(this.getReadAddress() - 1);
            transport.sendShort(this.getReadQuantity());
            transport.sendShort(this.getWriteAddress() - 1);
            transport.sendShort(writeValues.length);
            transport.sendByte(writeValues.length * 2);
            for (short value : writeValues) {
                transport.sendShort(value);
            }
            Request.writeSuffix(transport);
        }

        private void _setReadAddress(int readAddress) {
            this.setAddress(readAddress);
        }

        private void _setReadQuantity(int readQuantity) {
            this.setQuantity(readQuantity);
        }

        private void _setWriteAddress(int writeAddress) {
            this._address = writeAddress & 0xFFFF;
        }

        private void _setWriteValues(short[] values) {
            this._values = values;
        }
    }
}

