/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPTransaction;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.Transaction;

public interface WriteTransaction {

    public static abstract class Response
    extends Transaction.Response
    implements PAPTransaction.Response {
        protected Response(@Nonnull Request request) {
            super(request);
        }

        protected Response(@Nonnull Prefix prefix, @Nonnull Request request) {
            super(prefix, request);
        }

        @Override
        public Request getRequest() {
            return (Request)super.getRequest();
        }
    }

    public static abstract class Request
    extends Transaction.Request
    implements PAPTransaction.Request {
        private int _address;
        private PointValue _pointValue;
        private final DateTime _stamp = DateTime.now();
        private short[] _values;

        protected Request() {
        }

        protected Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        @CheckReturnValue
        public final int getAddress() {
            return this._address;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<PointValue> getPointValue() {
            return Optional.ofNullable(this._pointValue);
        }

        @Override
        public DateTime getStamp() {
            return this._stamp;
        }

        @CheckReturnValue
        public final short getValue() {
            return this._values != null && this._values.length > 0 ? this._values[0] : (short)0;
        }

        @Nonnull
        @CheckReturnValue
        public final short[] getValues() {
            return this._values != null ? this._values : Transaction.NO_VALUES;
        }

        @Override
        public int getWriteAddress() {
            return this.getAddress();
        }

        @Override
        public short[] getWriteValues() {
            return this.getValues();
        }

        public void setPointValue(@Nonnull PointValue pointValue) {
            this._pointValue = (PointValue)Require.notNull((Object)pointValue);
        }

        protected void setAddress(int address) {
            this._address = address & 0xFFFF;
        }

        protected void setValue(int value) {
            this.setValues(new short[]{(short)value});
        }

        protected void setValues(@Nonnull short[] values) {
            this._values = values;
        }
    }
}

