/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.Register;

public final class BitsRegister
extends Register {
    private short _content;
    private final Point[] _points = new Point[16];

    public BitsRegister(@Nonnull Optional<Integer> address, boolean readOnly) {
        super(address, readOnly);
    }

    @Override
    public ReadTransaction.Request createReadRequest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WriteTransaction.Request createWriteRequest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getContent() {
        return this._content;
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues = new PointValue[this._points.length];
        for (int i = 0; i < this._points.length; ++i) {
            if (this._points[i] == null) continue;
            pointValues[i] = new PointValue(this._points[i], Optional.empty(), null, (Serializable)((this.getContent() >> i & 1) != 0 ? Boolean.TRUE : Boolean.FALSE));
        }
        return pointValues;
    }

    @Override
    public Point[] getPoints() {
        return this._points;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        Point point = (Point)pointValue.getPoint().get();
        for (int i = 0; i < this._points.length; ++i) {
            if (point != this._points[i]) continue;
            Serializable value = pointValue.getValue();
            short mask = (short)(1 << i);
            boolean valueIsOn = value instanceof Boolean ? (Boolean)value : (value instanceof Number ? ((Number)value).intValue() != 0 : false);
            if (valueIsOn) {
                this.setContent((short)(this.getContent() | mask));
                break;
            }
            this.setContent((short)(this.getContent() & ~mask));
            break;
        }
    }

    @Override
    public void setContent(short content) {
        this._content = content;
    }

    public boolean setPoint(@Nonnull Optional<Point> point, int bit) {
        if (this._points[bit] != null) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.OVERLOADED_BIT, new Object[]{point, this._points[bit], bit});
            return false;
        }
        this._points[bit] = point.orElse(null);
        return true;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }
}

