/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.message.ReadCoils;
import org.rvpf.pap.modbus.message.ReadDiscreteInputs;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.WriteSingleCoil;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.Register;

public final class DiscreteRegister
extends Register {
    private short _content;
    private final Point[] _points;

    public DiscreteRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean readOnly) {
        super(address, readOnly);
        Point[] pointArray;
        if (point.isPresent()) {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = point.get();
        } else {
            pointArray = NO_POINTS;
        }
        this._points = pointArray;
    }

    @Override
    public ReadTransaction.Request createReadRequest() {
        int startingAddress = this.getAddress().get();
        return this.isReadOnly() ? new ReadDiscreteInputs.Request(startingAddress, this.size()) : new ReadCoils.Request(startingAddress, this.size());
    }

    @Override
    public WriteTransaction.Request createWriteRequest() {
        return new WriteSingleCoil.Request(this.getAddress().get(), this.getContent());
    }

    @Override
    public short getContent() {
        return this._content;
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues = this._points != NO_POINTS ? new PointValue[]{new PointValue(this._points[0], Optional.empty(), null, (Serializable)Boolean.valueOf(this.getContent() != 0))} : NO_POINT_VALUES;
        return pointValues;
    }

    @Override
    public Point[] getPoints() {
        return this._points;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        boolean valueIsOn = value instanceof Boolean ? (Boolean)value : (value instanceof Number ? ((Number)value).intValue() != 0 : false);
        this.setContent((short)(valueIsOn ? 1 : 0));
    }

    @Override
    public void setContent(short content) {
        this._content = content;
    }

    @Override
    public int size() {
        return 1;
    }
}

