/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.modbus.message.WriteMultipleRegisters;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.WordRegister;

public class DoubleWordRegister
extends WordRegister {
    private final boolean _middleEndian;
    private final WordRegister _nextRegister;

    public DoubleWordRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean readOnly, boolean middleEndian) {
        super(address, point, readOnly);
        this._middleEndian = middleEndian;
        this._nextRegister = new WordRegister(Optional.of(address.get() + 1), Optional.empty(), readOnly);
    }

    @Override
    public WriteTransaction.Request createWriteRequest() {
        short[] contents = new short[]{this.getContent(), this.getNextRegister().getContent()};
        return new WriteMultipleRegisters.Request(this.getAddress().get(), contents);
    }

    @Nonnull
    @CheckReturnValue
    public final WordRegister getNextRegister() {
        return this._nextRegister;
    }

    @Override
    public void setContents(@Nonnull short[] contents) {
        Require.equal((long)this.size(), (long)contents.length);
        this.setContent(contents[0]);
        this.getNextRegister().setContent(contents[1]);
    }

    @Override
    public int size() {
        return 2;
    }

    protected boolean isMiddleEndian() {
        return this._middleEndian;
    }
}

