/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.register.DoubleWordRegister;

public class IntegerRegister
extends DoubleWordRegister {
    private final boolean _signed;

    public IntegerRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean signed, boolean readOnly, boolean middleEndian) {
        super(address, point, readOnly, middleEndian);
        this._signed = signed;
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues;
        if (this.getPoints() != NO_POINTS) {
            Number value = this._signed ? (Number)this.getInt() : (Number)((long)this.getInt() & 0xFFFFFFFFL);
            pointValues = new PointValue[]{new PointValue(this.getPoints()[0], Optional.empty(), null, (Serializable)value)};
        } else {
            pointValues = NO_POINT_VALUES;
        }
        return pointValues;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        this.setInt(pointValue.getValue() instanceof Number ? ((Number)pointValue.getValue()).intValue() : 0);
    }

    @CheckReturnValue
    protected int getInt() {
        int intValue = this.isMiddleEndian() ? (this.getContent() & 0xFFFF) + (this.getNextRegister().getContent() << 16) : (this.getContent() << 16) + (this.getNextRegister().getContent() & 0xFFFF);
        return intValue;
    }

    protected void setInt(int intValue) {
        if (this.isMiddleEndian()) {
            this.setContent((short)intValue);
            this.getNextRegister().setContent((short)(intValue >> 16));
        } else {
            this.setContent((short)(intValue >> 16));
            this.getNextRegister().setContent((short)intValue);
        }
    }
}

