/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.register.QuadWordRegister;

public class LongRegister
extends QuadWordRegister {
    public LongRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean readOnly, boolean middleEndian) {
        super(address, point, readOnly, middleEndian);
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues = this.getPoints() != NO_POINTS ? new PointValue[]{new PointValue(this.getPoints()[0], Optional.empty(), null, (Serializable)Long.valueOf(this.getLong()))} : NO_POINT_VALUES;
        return pointValues;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        this.setLong(pointValue.getValue() instanceof Number ? ((Number)pointValue.getValue()).longValue() : 0L);
    }

    @CheckReturnValue
    protected long getLong() {
        int limit = this.size() - 1;
        long longValue = 0L;
        if (this.isMiddleEndian()) {
            for (int i = limit; i >= 0; --i) {
                longValue <<= 16;
                longValue |= (long)(this.getWordRegister(i).getContent() & 0xFFFF);
            }
        } else {
            for (int i = 0; i <= limit; ++i) {
                longValue <<= 16;
                longValue |= (long)(this.getWordRegister(i).getContent() & 0xFFFF);
            }
        }
        return longValue;
    }

    protected void setLong(long longValue) {
        int limit = this.size() - 1;
        if (this.isMiddleEndian()) {
            for (int i = 0; i <= limit; ++i) {
                this.getWordRegister(i).setContent((short)longValue);
                longValue >>= 16;
            }
        } else {
            for (int i = limit; i >= 0; --i) {
                this.getWordRegister(i).setContent((short)longValue);
                longValue >>= 16;
            }
        }
    }
}

