/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.pap.modbus.register.DoubleWordRegister;
import org.rvpf.pap.modbus.register.WordRegister;

public abstract class QuadWordRegister
extends DoubleWordRegister {
    private final DoubleWordRegister _nextRegister;

    public QuadWordRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean readOnly, boolean middleEndian) {
        super(address, point, readOnly, middleEndian);
        this._nextRegister = new DoubleWordRegister(Optional.of(address.get() + 2), Optional.empty(), readOnly, middleEndian);
    }

    @Nonnull
    @CheckReturnValue
    public WordRegister getWordRegister(int index) {
        switch (index) {
            case 0: {
                return this;
            }
            case 1: {
                return this.getNextRegister();
            }
            case 2: {
                return this._nextRegister;
            }
            case 3: {
                return this._nextRegister.getNextRegister();
            }
        }
        throw new InternalError();
    }

    @Override
    public int size() {
        return 4;
    }
}

