/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.WriteTransaction;

public abstract class Register {
    protected static final Point[] NO_POINTS = new Point[0];
    protected static final PointValue[] NO_POINT_VALUES = new PointValue[0];
    private final Optional<Integer> _address;
    private final boolean _readOnly;

    protected Register(@Nonnull Optional<Integer> address, boolean readOnly) {
        this._address = address;
        this._readOnly = readOnly;
    }

    @Nonnull
    @CheckReturnValue
    public abstract ReadTransaction.Request createReadRequest();

    @Nonnull
    @CheckReturnValue
    public abstract WriteTransaction.Request createWriteRequest();

    @Nonnull
    @CheckReturnValue
    public Optional<Integer> getAddress() {
        return this._address;
    }

    @CheckReturnValue
    public abstract short getContent();

    @Nonnull
    @CheckReturnValue
    public abstract PointValue[] getPointValues();

    @Nonnull
    @CheckReturnValue
    public abstract Point[] getPoints();

    @CheckReturnValue
    public final boolean isReadOnly() {
        return this._readOnly;
    }

    public abstract void putPointValue(@Nonnull PointValue var1);

    public abstract void setContent(short var1);

    public void setContents(@Nonnull short[] contents) {
        this.setContent(contents[0]);
    }

    @CheckReturnValue
    public abstract int size();

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return Logger.getInstance(this.getClass());
    }
}

