/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.register.DoubleWordRegister;

public final class StampRegister
extends DoubleWordRegister {
    private final ModbusProxy _remoteProxy;

    public StampRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<ModbusProxy> remoteProxy, boolean readOnly, boolean middleEndian) {
        super(address, Optional.empty(), readOnly, middleEndian);
        this._remoteProxy = remoteProxy.orElse(null);
    }

    @Override
    public PointValue[] getPointValues() {
        DateTime now = DateTime.now();
        int seconds = (int)(now.scaled(ElapsedTime.SECOND) % 3600.0);
        DateTime stamp = now.floored(ElapsedTime.HOUR);
        if (seconds < 900) {
            if (this.getContent() > 2700) {
                stamp = stamp.before(ElapsedTime.HOUR);
            }
        } else if (seconds > 2700 && this.getContent() < 900) {
            stamp = stamp.after(ElapsedTime.HOUR);
        }
        if (this._remoteProxy != null) {
            stamp = stamp.after((long)this.getContent() * ElapsedTime.SECOND.toRaw() + (long)this.getNextRegister().getContent() * (ElapsedTime.MILLI.toRaw() / 10L));
            this._remoteProxy.setStamp(Optional.of(stamp));
        }
        return NO_POINT_VALUES;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
    }

    @Override
    public void setContent(short content) {
        super.setContent(content);
        this.getNextRegister().setContent((short)0);
    }
}

