/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.pap.modbus.message.ReadHoldingRegisters;
import org.rvpf.pap.modbus.message.ReadInputRegisters;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.WriteMultipleRegisters;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.ArrayRegister;

public final class WordArrayRegister
extends ArrayRegister {
    public WordArrayRegister(@Nonnull Optional<Integer> address, int size, @Nonnull Optional<Point> point, boolean readOnly) {
        super(address, size, point, readOnly);
    }

    @Override
    public ReadTransaction.Request createReadRequest() {
        int startingAddress = this.getAddress().get();
        return this.isReadOnly() ? new ReadInputRegisters.Request(startingAddress, this.size()) : new ReadHoldingRegisters.Request(startingAddress, this.size());
    }

    @Override
    public WriteTransaction.Request createWriteRequest() {
        return new WriteMultipleRegisters.Request(this.getAddress().get(), this.getContents());
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues;
        if (this.getPoints() != NO_POINTS) {
            short[] contents = this.getContents();
            Tuple tuple = new Tuple(contents.length);
            for (short content : contents) {
                tuple.add((Serializable)Short.valueOf(content));
            }
            pointValues = new PointValue[]{new PointValue(this.getPoints()[0], Optional.empty(), null, (Serializable)tuple)};
        } else {
            pointValues = NO_POINT_VALUES;
        }
        return pointValues;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        Serializable values = pointValue.getValue();
        if (!(values instanceof Tuple)) {
            throw new IllegalArgumentException();
        }
        Tuple tuple = (Tuple)values;
        if (tuple.size() != this.size()) {
            throw new IllegalArgumentException();
        }
        short[] contents = this.getContents();
        for (int i = 0; i < contents.length; ++i) {
            Serializable value = tuple.get(i);
            contents[i] = value instanceof Number ? ((Number)value).shortValue() : (short)0;
        }
    }
}

