/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.transport;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.TimeoutMonitor;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusServerProxy;
import org.rvpf.pap.modbus.message.ErrorResponse;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.transport.Connection;
import org.rvpf.pap.modbus.transport.Transport;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class ClientConnection
extends Connection
implements ServiceThread.Target,
TimeoutMonitor.Client {
    private final BlockingQueue<Transaction.Request> _batchedRequests;
    private boolean _busy;
    private volatile Exception _exception;
    private final Queue<Transaction.Request> _pendingRequests = new LinkedList<Transaction.Request>();
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();
    private final TimeoutMonitor _timeoutMonitor;

    public ClientConnection(@Nonnull Transport transport, @Nonnull ModbusServerProxy serverProxy, @Nonnull PAPConnectionListener listener) {
        super(transport, serverProxy, Optional.of(listener));
        transport.setBatchSize(serverProxy.getBatchSize());
        transport.setLittleEndian(serverProxy.isLittleEndian());
        this._batchedRequests = new LinkedBlockingDeque<Transaction.Request>(transport.getBatchSize());
        this._timeoutMonitor = serverProxy.getRequestTimeout().isInfinity() ? null : new TimeoutMonitor(serverProxy.getRequestTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeoutMonitoring() {
        Queue<Transaction.Request> queue = this._pendingRequests;
        synchronized (queue) {
            Message message = new Message((Messages.Entry)ModbusMessages.TIMEOUT_ON_REQUEST, new Object[]{this.getRemoteName().orElse(null), this.getRemoteAddress()});
            this.getThisLogger().warn(message);
            this._exception = new TimeoutException(message.toString());
            this.stop();
        }
    }

    /*
     * Exception decompiling
     */
    public void run() throws InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 32[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(@Nonnull Transaction.Request request) {
        try {
            Queue<Transaction.Request> queue = this._pendingRequests;
            synchronized (queue) {
                request.setState(Transaction.State.QUEUED);
                if (!this._busy && this._pendingRequests.isEmpty()) {
                    if (this._batchedRequests.isEmpty()) {
                        this._batchedRequests.add(request);
                        this._doSendRequest(request);
                        this._activateTimeout();
                    } else if (!this._batchedRequests.offer(request)) {
                        this._pendingRequests.add(request);
                    }
                } else {
                    this._pendingRequests.add(request);
                }
            }
        }
        catch (IOException exception) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.FAILED_SEND_REQUEST, new Object[]{this.getTransport().getRemoteAddress(), exception});
            this._exception = exception;
            this.stop();
        }
    }

    @Override
    public void start() {
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "Modbus client (receiver from " + this.getRemoteAddress() + ")");
        if (this._thread.compareAndSet(null, thread)) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
            Require.ignored((boolean)this.getListener().get().onNewConnection(this.getRemoteProxy()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Thread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this._deactivateTimeout();
            if (this._timeoutMonitor != null) {
                TimeoutMonitor.shutdown();
            }
            if (thread != Thread.currentThread()) {
                this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            }
            this.close();
            Require.ignored((boolean)this.getListener().get().onLostConnection(this.getRemoteProxy(), Optional.ofNullable(this._exception)));
            this._exception = null;
            Queue<Transaction.Request> queue = this._pendingRequests;
            synchronized (queue) {
                for (Transaction.Request request : this._pendingRequests) {
                    request.setState(Transaction.State.FAILED);
                }
                this._pendingRequests.clear();
                for (Transaction.Request request : this._batchedRequests) {
                    request.setState(Transaction.State.FAILED);
                }
                this._batchedRequests.clear();
            }
            if (thread != Thread.currentThread()) {
                try {
                    thread.join();
                }
                catch (InterruptedException exception) {
                    throw new RuntimeException(exception);
                }
            }
            super.stop();
        }
    }

    private void _activateTimeout() {
        if (this._timeoutMonitor != null) {
            this._timeoutMonitor.setClient((TimeoutMonitor.Client)this);
        }
    }

    private void _deactivateTimeout() {
        if (this._timeoutMonitor != null) {
            this._timeoutMonitor.clearClient();
        }
    }

    private void _doSendRequest(Transaction.Request request) throws IOException {
        this.getThisLogger().trace((Messages.Entry)ModbusMessages.SENDING_REQUEST, new Object[]{request.getName()});
        Transport transport = this.getTransport();
        try {
            transport.onMessageSendBegins();
            request.write(transport);
            transport.flush();
        }
        catch (IOException exception) {
            request.setState(Transaction.State.FAILED);
            throw exception;
        }
        request.setState(Transaction.State.SENT);
    }

    private void _processResponse(Transaction.Response response, Transport transport) throws IOException, Transaction.FormatException {
        response.read(transport);
        if (response instanceof ErrorResponse) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.RECEIVED_ERROR_RESPONSE, new Object[]{((ErrorResponse)response).getExceptionCodeName()});
        } else {
            this.getThisLogger().trace((Messages.Entry)ModbusMessages.RECEIVED_RESPONSE, new Object[]{response.getName()});
        }
        ((ModbusServerProxy)this.getRemoteProxy()).putResponse(response);
    }
}

