/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.transport;

import java.io.IOException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.PAPConnection;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.transport.Transport;

public abstract class Connection
extends PAPConnection.Abstract {
    private final Optional<PAPConnectionListener> _listener;
    private final ModbusProxy _remoteProxy;
    private final Transport _transport;

    Connection(@Nonnull Transport transport, @Nonnull ModbusProxy remoteProxy, @Nonnull Optional<PAPConnectionListener> listener) {
        this._transport = (Transport)Require.notNull((Object)transport);
        this._remoteProxy = (ModbusProxy)Require.notNull((Object)remoteProxy);
        this._listener = (Optional)Require.notNull(listener);
    }

    @Nonnull
    @CheckReturnValue
    public final String getRemoteAddress() {
        return this._transport.getRemoteAddress();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getRemoteName() {
        return this.getRemoteProxy().getOrigin().getName();
    }

    @Nonnull
    @CheckReturnValue
    public ModbusProxy getRemoteProxy() {
        return this._remoteProxy;
    }

    public abstract void start();

    public void stop() {
        this._remoteProxy.forgetConnection();
    }

    @Override
    protected final void doClose() throws IOException {
        this.getThisLogger().debug((Messages.Entry)ModbusMessages.CLOSING_CONNECTION, new Object[]{this._transport.getRemoteAddress()});
        this._transport.close();
    }

    @Override
    protected String getName() {
        return this.getRemoteAddress();
    }

    @Nonnull
    @CheckReturnValue
    Optional<PAPConnectionListener> getListener() {
        return this._listener;
    }

    @Nonnull
    @CheckReturnValue
    Transport getTransport() {
        return this._transport;
    }
}

