/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.transport;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Messages;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.modbus.ModbusClientProxy;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.transport.Connection;
import org.rvpf.pap.modbus.transport.Responder;
import org.rvpf.pap.modbus.transport.Transport;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class ServerConnection
extends Connection
implements ServiceThread.Target {
    private final ModbusClientProxy _clientProxy;
    private final Responder _responder;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();
    private final boolean _writeOnly;

    public ServerConnection(@Nonnull Transport transport, @Nonnull ModbusClientProxy clientProxy, @Nonnull Optional<PAPConnectionListener> listener, boolean writeOnly) {
        super(transport, clientProxy, listener);
        this._clientProxy = clientProxy;
        this._writeOnly = writeOnly;
        this._responder = new Responder(this);
        transport.setLittleEndian(this._clientProxy.isLittleEndian());
        this._clientProxy.setConnection(this);
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 17[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void sendResponse(@Nonnull Transaction.Response response) {
        this._responder.addResponse(response);
    }

    @Override
    public void start() {
        this._responder.start();
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "Modbus server (receiver from " + this.getRemoteAddress() + ")");
        if (this._thread.compareAndSet(null, thread)) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    @Override
    public void stop() {
        Thread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            this.close();
            if (thread != Thread.currentThread()) {
                try {
                    thread.join();
                }
                catch (InterruptedException exception) {
                    throw new RuntimeException(exception);
                }
            }
            this._responder.stop();
            super.stop();
        }
    }
}

