/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.server.pap.modbus;

import java.util.Optional;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.modbus.ModbusServer;
import org.rvpf.pap.modbus.ModbusSupport;
import org.rvpf.store.server.StoreServiceAppImpl;
import org.rvpf.store.server.pap.PAPUpdatesListener;

public final class ModbusUpdatesListener
extends PAPUpdatesListener {
    private String[] _originNames;
    private volatile ModbusServer _server;

    public void onMetadataRefreshed(Metadata metadata) {
        ModbusServer server;
        super.onMetadataRefreshed(metadata);
        ModbusSupport support = new ModbusSupport();
        PAPContext serverContext = support.newServerContext(metadata, this._originNames, Optional.empty());
        ModbusServer modbusServer = server = serverContext != null ? support.newServer(serverContext) : null;
        if (server != null) {
            this._server = server;
        }
    }

    @Override
    public boolean setUp(StoreServiceAppImpl storeAppImpl, KeyedGroups updatesListenerProperties) {
        if (!super.setUp(storeAppImpl, updatesListenerProperties)) {
            return false;
        }
        KeyedGroups modbusProperties = updatesListenerProperties.getGroup("modbus");
        this._originNames = modbusProperties.getStrings("origin");
        ModbusSupport support = new ModbusSupport();
        PAPContext serverContext = support.newServerContext(storeAppImpl.getMetadata(), this._originNames, Optional.empty());
        ModbusServer modbusServer = this._server = serverContext != null ? support.newServer(serverContext) : null;
        if (this._server == null || !this._server.setUp(modbusProperties)) {
            return false;
        }
        this._server.setResponder(this);
        return true;
    }

    public void tearDown() {
        super.tearDown();
    }

    protected void doCommit() throws InterruptedException {
        this._server.onUpdatesCommit();
    }

    protected void doStart() throws InterruptedException {
        super.doStart();
        this._server.start();
    }

    protected void doStop() {
        ModbusServer server = this._server;
        if (server != null) {
            server.stop();
        }
    }

    protected Optional<PointValue> nextUpdate(int limit, boolean wait) throws InterruptedException {
        Optional<PointValue> pointValue = this._server.nextUpdate(wait ? -1L : 0L);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return pointValue;
    }
}

