/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input.pap.dnp3;

import java.util.Optional;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.input.pap.PAPModule;
import org.rvpf.pap.PAPServer;
import org.rvpf.pap.dnp3.DNP3Support;

public final class DNP3Module
extends PAPModule {
    private static final Optional<ElapsedTime> _DEFAULT_BATCH_WAIT = Optional.of(ElapsedTime.fromRaw((long)(1L * ElapsedTime.MINUTE.toRaw())));

    protected Optional<ElapsedTime> getDefaultBatchWait() {
        return _DEFAULT_BATCH_WAIT;
    }

    @Override
    protected PAPModule.PAPInput newInput(PAPServer server) {
        return new _DNP3Input(server);
    }

    @Override
    protected DNP3Support newSupport() {
        return new DNP3Support();
    }

    @Override
    protected KeyedGroups protocolProperties(KeyedGroups moduleProperties) {
        return moduleProperties.getGroup("dnp3");
    }

    @Override
    protected String usage() {
        return "DNP3";
    }

    private final class _DNP3Input
    extends PAPModule.PAPInput {
        _DNP3Input(PAPServer outstation) {
            super(DNP3Module.this, outstation);
        }

        public String getDisplayName() {
            return "DNP3 input";
        }

        public String getSourceName() {
            return "DNP3";
        }
    }
}

