/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.Attributes;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Content;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Traces;
import org.rvpf.content.BooleanContent;
import org.rvpf.content.NumberContent;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3Proxy;
import org.rvpf.pap.dnp3.DNP3StationPoint;
import org.rvpf.pap.dnp3.DNP3Support;
import org.rvpf.pap.dnp3.object.ObjectRange;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.transport.LogicalDevice;

public abstract class DNP3Context
extends PAPContext {
    private static final int _ADDRESS_GROUP = 2;
    private static final LogicalDevice _DEFAULT_LOGICAL_DEVICE = new LogicalDevice("", (short)2);
    private static final Pattern _LOGICAL_DEVICE_PATTERN = Pattern.compile("([^:\\s]*)(?:\\s*[:]\\s*([0-9]+))?");
    private static final int _NAME_GROUP = 1;
    private final Map<PointType, Map<ObjectRange, Point>> _pointsByType = new HashMap<PointType, Map<ObjectRange, Point>>();
    private final Map<String, DNP3Proxy> _remoteProxyBySerialPortName = new HashMap<String, DNP3Proxy>();
    private final Map<InetAddress, DNP3Proxy> _remoteProxyByTCPAddress = new HashMap<InetAddress, DNP3Proxy>();
    private final Map<InetAddress, DNP3Proxy> _remoteProxyByUDPAddress = new HashMap<InetAddress, DNP3Proxy>();
    private final Map<Point, DNP3StationPoint> _remotePointsMap = new ConcurrentHashMap<Point, DNP3StationPoint>();

    protected DNP3Context(@Nonnull Optional<Metadata> metadata, @Nonnull Optional<Traces> traces) {
        super(new DNP3Support(), metadata, traces);
        for (PointType pointType : EnumSet.allOf(PointType.class)) {
            this._pointsByType.put(pointType, new ConcurrentHashMap());
        }
    }

    @Override
    public boolean addRemoteOrigin(Origin remoteOrigin, Attributes originAttributes) {
        LogicalDevice[] logicalDevices;
        boolean isFirstProxy = this.getRemoteProxyByOrigin().isEmpty();
        if (this._remoteProxyByTCPAddress.isEmpty() && !isFirstProxy) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.WILDCARD_ADDRESS_RESTRICTS, new Object[0]);
            return false;
        }
        DNP3Proxy remoteProxy = this.newRemoteProxy(remoteOrigin);
        if (!remoteProxy.setUp(originAttributes)) {
            return false;
        }
        if (!this._addTCPAddressesforRemoteProxy(remoteProxy, isFirstProxy, originAttributes)) {
            return false;
        }
        if (!this._addUDPAddressesForRemoteProxy(remoteProxy, isFirstProxy, originAttributes)) {
            return false;
        }
        String serialPortName = remoteProxy.getSerialPortName();
        if (!serialPortName.isEmpty()) {
            this._remoteProxyBySerialPortName.put(serialPortName.toUpperCase(Locale.ROOT), remoteProxy);
        }
        if ((logicalDevices = this.logicalDevices(originAttributes.getStrings("LOGICAL_DEVICE"), remoteProxy.getName().orElse(null))) == null) {
            return false;
        }
        Arrays.stream(logicalDevices).forEach(logicalDevice -> remoteProxy.registerLogicalDevice((LogicalDevice)logicalDevice));
        this.registerRemoteProxy(remoteProxy);
        return true;
    }

    @Override
    public boolean addRemotePoint(Point remotePoint, Attributes pointAttributes) {
        if (!((PointEntity)remotePoint).setUp(this.getMetadata())) {
            return false;
        }
        DNP3Proxy remoteProxy = this.getRemoteProxy(remotePoint).orElse(null);
        if (remoteProxy == null) {
            return false;
        }
        if (pointAttributes.getBoolean("CONNECTION_STATE")) {
            return true;
        }
        LogicalDevice logicalDevice = this._logicalDevice(remotePoint);
        ObjectRange objectRange = this._objectRange(remotePoint);
        PointType pointType = this._pointType(remotePoint);
        DataType dataType = this._dataType(remotePoint, pointType);
        if (logicalDevice == null || objectRange == null || pointType == null || dataType == null) {
            return false;
        }
        this._remotePointsMap.put(remotePoint, new DNP3StationPoint(remotePoint, logicalDevice, pointType, objectRange, dataType));
        this.registerRemotePoint(remotePoint);
        Map<ObjectRange, Point> points = this._pointsByType.get((Object)pointType);
        Point previousPoint = points.put(objectRange, remotePoint);
        if (previousPoint != null) {
            this.getThisLogger().warn((Messages.Entry)DNP3Messages.RECONFIGURED_OBJECT, new Object[]{pointType, objectRange, previousPoint, remotePoint});
            return false;
        }
        return true;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Point> getPoint(@Nonnull PointType pointType, @Nonnull ObjectRange objectRange) {
        Map<ObjectRange, Point> points = this._pointsByType.get((Object)pointType);
        Point point = points.get(objectRange);
        if (point == null) {
            Logger.getInstance(this.getClass()).warn((Messages.Entry)DNP3Messages.UNCONFIGURED_OBJECT, new Object[]{pointType, String.valueOf(objectRange.getStartIndex())});
            point = Point.NULL;
            points.put(objectRange, point);
        }
        return point != Point.NULL ? Optional.of(point) : Optional.empty();
    }

    @Override
    public String getProtocolName() {
        return "DNP3";
    }

    public Collection<? extends DNP3Proxy> getRemoteProxies() {
        return super.getRemoteProxies();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<DNP3Proxy> getRemoteProxyBySerialPortName(@Nonnull String serialPortName) {
        return Optional.ofNullable(this._remoteProxyBySerialPortName.get(serialPortName.trim().toUpperCase(Locale.ROOT)));
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<DNP3Proxy> getRemoteProxyByTCPAddress(@Nonnull InetAddress address) {
        Collection<? extends DNP3Proxy> remoteProxies;
        Object remoteProxy = this._remoteProxyByTCPAddress.isEmpty() ? ((remoteProxies = this.getRemoteProxies()).isEmpty() ? null : remoteProxies.iterator().next()) : this._remoteProxyByTCPAddress.get(address);
        return Optional.ofNullable(remoteProxy);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<DNP3Proxy> getRemoteProxyByUDPAddress(@Nonnull InetAddress address) {
        Collection<? extends DNP3Proxy> remoteProxies;
        Object remoteProxy = this._remoteProxyByUDPAddress.isEmpty() ? ((remoteProxies = this.getRemoteProxies()).isEmpty() ? null : remoteProxies.iterator().next()) : this._remoteProxyByUDPAddress.get(address);
        return Optional.ofNullable(remoteProxy);
    }

    @Nonnull
    @CheckReturnValue
    public DNP3StationPoint getRemoteStationPoint(@Nonnull Point point) {
        DNP3StationPoint stationPoint = this._remotePointsMap.get(point);
        if (stationPoint == null) {
            throw new IllegalArgumentException("Point unknown in DNP3 context: " + point);
        }
        return stationPoint;
    }

    @Nullable
    @CheckReturnValue
    public final LogicalDevice[] logicalDevices(@Nonnull String[] logicalDeviceDecls, @Nonnull String endPointName) {
        LogicalDevice[] logicalDevices = new LogicalDevice[logicalDeviceDecls.length];
        for (int i = 0; i < logicalDevices.length; ++i) {
            Short address;
            String logicalDeviceDecl = logicalDeviceDecls[i];
            Matcher logicalDeviceMatcher = _LOGICAL_DEVICE_PATTERN.matcher(logicalDeviceDecl.trim());
            if (!logicalDeviceMatcher.matches()) {
                throw new InternalError();
            }
            String namePart = logicalDeviceMatcher.group(1);
            String addressPart = logicalDeviceMatcher.group(2);
            if (namePart.isEmpty() && addressPart == null) {
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.BAD_LOGICAL_DEVICE, new Object[]{logicalDeviceDecl, endPointName});
                return null;
            }
            if (addressPart == null) {
                addressPart = namePart;
                namePart = "";
            }
            try {
                address = Short.valueOf(addressPart);
            }
            catch (NumberFormatException exception) {
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.BAD_LOGICAL_DEVICE, new Object[]{logicalDeviceDecl, endPointName});
                return null;
            }
            logicalDevices[i] = new LogicalDevice(namePart, address);
        }
        return logicalDevices;
    }

    @Override
    protected int getDefaultPortForRemoteOrigin() {
        return 20000;
    }

    @Override
    protected abstract DNP3Proxy newRemoteProxy(Origin var1);

    private boolean _addTCPAddressesforRemoteProxy(DNP3Proxy remoteProxy, boolean isFirstProxy, Attributes originAttributes) {
        String[] socketAddressStrings;
        for (String remoteProxyAddress : socketAddressStrings = originAttributes.getStrings("TCP_ADDRESS")) {
            if (remoteProxy.supportsWildcardAddress() && "*".equals(remoteProxyAddress.trim())) {
                if (!isFirstProxy || socketAddressStrings.length > 1) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.WILDCARD_ADDRESS_RESTRICTS, new Object[0]);
                    return false;
                }
                return true;
            }
            Optional socketAddress = Inet.socketAddress((String)remoteProxyAddress);
            if (!socketAddress.isPresent()) {
                this.getThisLogger().warn((Messages.Entry)BaseMessages.BAD_ADDRESS, new Object[]{remoteProxyAddress});
                return false;
            }
            int port = ((InetSocketAddress)socketAddress.get()).getPort();
            if (port <= 0) {
                port = originAttributes.getInt("TCP_PORT", this.getDefaultPortForRemoteOrigin());
            }
            try {
                int tcpPort = port;
                Arrays.stream(InetAddress.getAllByName(((InetSocketAddress)socketAddress.get()).getHostString())).forEach(address -> remoteProxy.addTCPSocketAddress(new InetSocketAddress((InetAddress)address, tcpPort)));
            }
            catch (UnknownHostException exception) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN_ADDRESS, new Object[]{remoteProxy.getOrigin(), remoteProxyAddress});
                return false;
            }
        }
        List<InetSocketAddress> socketAddresses = remoteProxy.getTCPSocketAddresses();
        for (InetSocketAddress socketAddress : socketAddresses) {
            DNP3Proxy otherProxy = this._remoteProxyByTCPAddress.get(socketAddress.getAddress());
            if (otherProxy != null) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.AMBIGUOUS_ORIGIN_ADDRESS, new Object[]{remoteProxy.getOrigin(), socketAddress.getAddress(), otherProxy.getOrigin()});
                return false;
            }
            this._remoteProxyByTCPAddress.put(socketAddress.getAddress(), remoteProxy);
        }
        return true;
    }

    private boolean _addUDPAddressesForRemoteProxy(DNP3Proxy remoteProxy, boolean isFirstProxy, Attributes originAttributes) {
        String[] socketAddressStrings = originAttributes.getStrings("UDP_ADDRESS");
        List<InetSocketAddress> socketAddresses = remoteProxy.getUDPSocketAddresses();
        for (String remoteProxyAddress : socketAddressStrings) {
            if (remoteProxy.supportsWildcardAddress() && "*".equals(remoteProxyAddress.trim())) {
                if (!isFirstProxy || socketAddressStrings.length > 1) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.WILDCARD_ADDRESS_RESTRICTS, new Object[0]);
                    return false;
                }
                return true;
            }
            Optional socketAddress = Inet.socketAddress((String)remoteProxyAddress);
            if (!socketAddress.isPresent()) {
                this.getThisLogger().warn((Messages.Entry)BaseMessages.BAD_ADDRESS, new Object[]{remoteProxyAddress});
                return false;
            }
            int port = ((InetSocketAddress)socketAddress.get()).getPort();
            if (port <= 0) {
                port = originAttributes.getInt("UDP_PORT", this.getDefaultPortForRemoteOrigin());
            }
            try {
                for (InetAddress address : InetAddress.getAllByName(((InetSocketAddress)socketAddress.get()).getHostString())) {
                    remoteProxy.addUDPSocketAddress(new InetSocketAddress(address, port));
                }
            }
            catch (UnknownHostException exception) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN_ADDRESS, new Object[]{remoteProxy.getOrigin(), remoteProxyAddress});
                return false;
            }
        }
        for (InetSocketAddress socketAddress : socketAddresses) {
            DNP3Proxy otherProxy = this._remoteProxyByUDPAddress.get(socketAddress.getAddress());
            if (otherProxy != null) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.AMBIGUOUS_ORIGIN_ADDRESS, new Object[]{remoteProxy.getOrigin(), socketAddress.getAddress(), otherProxy.getOrigin()});
                return false;
            }
            this._remoteProxyByUDPAddress.put(socketAddress.getAddress(), remoteProxy);
        }
        return true;
    }

    private DataType _dataType(Point remotePoint, PointType pointType) {
        if (pointType == null) {
            return null;
        }
        String dataTypeName = ((Attributes)remotePoint.getAttributes("DNP3").get()).getString("DATA_TYPE").orElse(null);
        DataType dataType = null;
        if (dataTypeName != null) {
            try {
                dataType = DataType.valueOf(dataTypeName.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException exception) {
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.UNKNOWN_DATA_TYPE, new Object[]{dataTypeName, remotePoint});
            }
        } else {
            Optional content = remotePoint.getContent();
            if (content.isPresent()) {
                dataType = pointType.getSupport().getDataType((Content)content.get()).orElse(DataType.ANY);
            }
        }
        if (dataType == null) {
            this.getThisLogger().warn((Messages.Entry)DNP3Messages.UNKNOWN_DATA_TYPE, new Object[]{"", remotePoint});
        }
        return dataType;
    }

    private LogicalDevice _logicalDevice(Point remotePoint) {
        Optional<LogicalDevice> logicalDevice;
        DNP3Proxy remoteProxy = (DNP3Proxy)this.getRemoteProxy(remotePoint).get();
        Optional pointAttributes = remotePoint.getAttributes("DNP3");
        if (!pointAttributes.isPresent()) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTES, new Object[]{"DNP3", remotePoint});
            return null;
        }
        String logicalDeviceAttribute = ((Attributes)pointAttributes.get()).getString("LOGICAL_DEVICE").orElse(null);
        if (logicalDeviceAttribute != null) {
            Matcher logicalDeviceMatcher = _LOGICAL_DEVICE_PATTERN.matcher(logicalDeviceAttribute.trim());
            if (!logicalDeviceMatcher.matches()) {
                throw new InternalError();
            }
            String namePart = logicalDeviceMatcher.group(1);
            String addressPart = logicalDeviceMatcher.group(2);
            if (addressPart == null) {
                if (namePart.isEmpty()) {
                    this.getThisLogger().warn((Messages.Entry)DNP3Messages.BAD_LOGICAL_DEVICE, new Object[]{logicalDeviceAttribute, remoteProxy.getName().orElse(null)});
                    return null;
                }
                logicalDevice = remoteProxy.getLogicalDevice(namePart);
                if (!logicalDevice.isPresent()) {
                    Short address;
                    try {
                        address = Short.valueOf(namePart);
                    }
                    catch (NumberFormatException exception) {
                        this.getThisLogger().warn((Messages.Entry)DNP3Messages.UNKNOWN_LOGICAL_DEVICE, new Object[]{namePart, remoteProxy.getName().orElse(null), remotePoint});
                        return null;
                    }
                    logicalDevice = remoteProxy.getLogicalDevice(address);
                    if (!logicalDevice.isPresent()) {
                        logicalDevice = Optional.of(new LogicalDevice("", address));
                        remoteProxy.registerLogicalDevice(logicalDevice.get());
                    }
                }
            } else {
                Short address;
                try {
                    address = Short.valueOf(addressPart);
                }
                catch (NumberFormatException exception) {
                    this.getThisLogger().warn((Messages.Entry)DNP3Messages.BAD_LOGICAL_DEVICE, new Object[]{addressPart, remoteProxy.getName().orElse(null)});
                    return null;
                }
                logicalDevice = remoteProxy.getLogicalDevice(address);
                if (!logicalDevice.isPresent()) {
                    logicalDevice = Optional.of(new LogicalDevice("", address));
                    remoteProxy.registerLogicalDevice(logicalDevice.get());
                }
            }
        } else {
            logicalDevice = remoteProxy.getLogicalDevice();
            if (!logicalDevice.isPresent()) {
                logicalDevice = Optional.of(_DEFAULT_LOGICAL_DEVICE);
            }
        }
        return logicalDevice.get();
    }

    private ObjectRange _objectRange(Point remotePoint) {
        ObjectRange objectRange;
        Attributes pointAttributes = (Attributes)remotePoint.getAttributes("DNP3").get();
        Optional index = pointAttributes.getInteger("INDEX", Optional.empty());
        if (index.isPresent()) {
            if (pointAttributes.containsValueKey("START_INDEX")) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.CONFLICTING_ATTRIBUTES, new Object[]{"INDEX", "START_INDEX", "DNP3"});
                objectRange = null;
            } else if (pointAttributes.containsValueKey("STOP_INDEX")) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.CONFLICTING_ATTRIBUTES, new Object[]{"INDEX", "STOP_INDEX", "DNP3"});
                objectRange = null;
            } else {
                objectRange = ObjectRange.newIndexInstance((Integer)index.get());
            }
        } else {
            Optional startIndex = pointAttributes.getInteger("START_INDEX", Optional.empty());
            Optional stopIndex = pointAttributes.getInteger("STOP_INDEX", Optional.empty());
            if (startIndex.isPresent()) {
                if (!stopIndex.isPresent()) {
                    this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"STOP_INDEX", "DNP3", remotePoint});
                    objectRange = null;
                } else {
                    objectRange = ObjectRange.newIndexInstance((Integer)startIndex.get(), (Integer)stopIndex.get());
                }
            } else if (stopIndex.isPresent()) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"START_INDEX", "DNP3", remotePoint});
                objectRange = null;
            } else {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"INDEX", "DNP3", remotePoint});
                objectRange = null;
            }
        }
        return objectRange;
    }

    private PointType _pointType(Point remotePoint) {
        PointType pointType;
        Attributes pointAttributes = (Attributes)remotePoint.getAttributes("DNP3").get();
        String pointTypeName = pointAttributes.getString("POINT_TYPE").orElse(null);
        if (pointTypeName != null) {
            try {
                pointType = PointType.valueOf(pointTypeName.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException exception) {
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.UNKNOWN_POINT_TYPE, new Object[]{pointTypeName, remotePoint});
                pointType = null;
            }
        } else {
            Content content = remotePoint.getContent().orElse(null);
            if (content != null) {
                pointType = content instanceof BooleanContent ? PointType.SINGLE_BIT_INPUT : (content instanceof NumberContent ? PointType.ANALOG_INPUT : null);
            } else {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"POINT_TYPE", "DNP3", remotePoint});
                pointType = null;
            }
        }
        return pointType;
    }
}

