/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.dnp3.DNP3Context;
import org.rvpf.pap.dnp3.DNP3OutstationProxy;
import org.rvpf.pap.dnp3.DNP3Proxy;

public final class DNP3MasterContext
extends DNP3Context {
    public DNP3MasterContext(@Nonnull Optional<Metadata> metadata, @Nonnull Optional<Traces> traces) {
        super(metadata, traces);
    }

    @Override
    public boolean addRemotePoint(Point remotePoint, Attributes pointAttributes) {
        if (pointAttributes.getBoolean("CONNECTION_STATE")) {
            Optional<? extends PAPProxy> remoteProxy = this.getRemoteProxy(remotePoint);
            if (!remoteProxy.isPresent()) {
                return false;
            }
            if (!remoteProxy.get().setConnectionStatePoint(remotePoint)) {
                return false;
            }
            this.registerRemotePoint(remotePoint);
            return true;
        }
        return super.addRemotePoint(remotePoint, pointAttributes);
    }

    @Override
    public boolean isClientContext() {
        return true;
    }

    @Override
    protected DNP3Proxy newRemoteProxy(Origin remoteOrigin) {
        return new DNP3OutstationProxy((DNP3Context)this, remoteOrigin);
    }
}

