/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.dnp3.DNP3Context;
import org.rvpf.pap.dnp3.DNP3MasterProxy;
import org.rvpf.pap.dnp3.DNP3Proxy;

public final class DNP3OutstationContext
extends DNP3Context {
    private final Map<String, Origin> _origins = new HashMap<String, Origin>();

    public DNP3OutstationContext(@Nonnull Optional<Metadata> metadata, @Nonnull String[] originNames, @Nonnull Optional<Traces> traces) {
        super(metadata, traces);
        for (String originName : originNames) {
            this._origins.put(originName.toUpperCase(Locale.ROOT), null);
        }
    }

    @Override
    public boolean isClientContext() {
        return false;
    }

    @Override
    protected boolean isRemoteOriginNeeded(Origin origin, Attributes originAttributes) {
        return this._origins.put((String)origin.getNameInUpperCase().get(), origin) == null;
    }

    @Override
    protected boolean isRemotePointNeeded(Point point, Attributes pointAttributes) {
        Optional origin = point.getOrigin();
        if (!origin.isPresent() || !point.getAttributes("DNP3").isPresent()) {
            return false;
        }
        return this._origins.get(((Origin)origin.get()).getNameInUpperCase().get()) != null;
    }

    @Override
    protected DNP3Proxy newRemoteProxy(Origin remoteOrigin) {
        return new DNP3MasterProxy((DNP3Context)this, remoteOrigin);
    }
}

