/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPSupport;
import org.rvpf.pap.dnp3.DNP3Master;
import org.rvpf.pap.dnp3.DNP3MasterContext;
import org.rvpf.pap.dnp3.DNP3Outstation;
import org.rvpf.pap.dnp3.DNP3OutstationContext;
import org.rvpf.processor.engine.pap.dnp3.DNP3Splitter;

public final class DNP3Support
extends PAPSupport.Abstract {
    public static final UUID METADATA_FILTER_UUID = (UUID)UUID.fromString((String)"3f7f1e8e-802d-4d74-ac41-e3132e9e0af9").get();

    @Override
    public String getAttributesUsage() {
        return "DNP3";
    }

    @Override
    public UUID getMetadataFilterUUID() {
        return METADATA_FILTER_UUID;
    }

    @Override
    public String getProtocolName() {
        return "DNP3";
    }

    @Override
    public DNP3Master newClient(PAPContext masterContext) {
        return this.newMaster((DNP3MasterContext)masterContext, (short)1);
    }

    @Override
    public DNP3MasterContext newClientContext(Metadata metadata, Optional<Traces> traces) {
        DNP3MasterContext masterContext = new DNP3MasterContext(Optional.of(metadata), traces);
        if (!masterContext.setUp()) {
            masterContext.tearDown();
            return null;
        }
        return masterContext;
    }

    @Nonnull
    @CheckReturnValue
    public DNP3Master newMaster(@Nonnull DNP3MasterContext masterContext, short localDeviceAddress) {
        return new DNP3Master(masterContext, localDeviceAddress);
    }

    @Nonnull
    @CheckReturnValue
    public DNP3Outstation newOutstation(@Nonnull DNP3OutstationContext outstationContext) {
        return new DNP3Outstation(outstationContext);
    }

    @Nullable
    @CheckReturnValue
    public DNP3OutstationContext newOutstationContext(@Nonnull Metadata metadata, @Nonnull String[] originNames, @Nonnull Optional<Traces> traces) {
        DNP3OutstationContext outstationContext = new DNP3OutstationContext(Optional.of(metadata), originNames, traces);
        if (!outstationContext.setUp()) {
            outstationContext.tearDown();
            return null;
        }
        return outstationContext;
    }

    @Override
    public DNP3Outstation newServer(PAPContext outstationContext) {
        return this.newOutstation((DNP3OutstationContext)outstationContext);
    }

    @Override
    public DNP3OutstationContext newServerContext(Metadata metadata, String[] originNames, Optional<Traces> traces) {
        return this.newOutstationContext(metadata, originNames, traces);
    }

    @Override
    public DNP3Splitter newSplitter() {
        return new DNP3Splitter();
    }

    @Override
    public String supportedValueTypeCodes() {
        return Externalizer.ValueType.setToString(EnumSet.of(Externalizer.ValueType.BOOLEAN, new Externalizer.ValueType[]{Externalizer.ValueType.BYTE, Externalizer.ValueType.DOUBLE, Externalizer.ValueType.FLOAT, Externalizer.ValueType.INTEGER, Externalizer.ValueType.LONG, Externalizer.ValueType.SHORT}));
    }
}

