/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.content;

import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;

public enum ControlStatusCode implements EnumCode
{
    SUCCESS(0),
    TIMEOUT(1),
    NO_SELECT(2),
    FORMAT_ERROR(3),
    NOT_SUPPORTED(4),
    ALREADY_ACTIVE(5),
    HARDWARE_ERROR(6),
    LOCAL(7),
    TOO_MANY_OBJS(8),
    NOT_AUTHORIZED(9),
    AUTOMATION_INHIBIT(10),
    PROCESSING_LIMITED(11),
    OUT_OF_RANGE(12),
    UNDEFINED(127);

    private static final Map<Integer, ControlStatusCode> _CODE_MAP;
    private final int _code;

    private ControlStatusCode(int code) {
        this._code = code;
    }

    @Nonnull
    @CheckReturnValue
    public static ControlStatusCode instance(int code) throws AssertionError {
        return (ControlStatusCode)Require.notNull((Object)_CODE_MAP.get(code), (Object)String.valueOf(code));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    static {
        _CODE_MAP = EnumCode.MapFactory.codeMap((Enum[])ControlStatusCode.values());
    }
}

