/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.content;

import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;

public enum FileStatusCode implements EnumCode
{
    SUCCESS(0),
    PERMISSION_DENIED(1),
    INVALID_MODE(2),
    FILE_NOT_FOUND(3),
    FILE_LOCKED(4),
    TOO_MANY_OPEN(5),
    INVALID_HANDLE(6),
    WRITE_BLOCK_SIZE(7),
    COMM_LOST(8),
    CANNOT_ABORT(9),
    NOT_OPENED(16),
    HANDLE_EXPIRED(17),
    BUFFER_OVERRUN(18),
    FATAL(19),
    BLOCK_SEQ(20),
    UNDEFINED(255);

    private static final Map<Integer, FileStatusCode> _CODE_MAP;
    private final int _code;

    private FileStatusCode(int code) {
        this._code = code;
    }

    @Nonnull
    @CheckReturnValue
    public static FileStatusCode instance(int code) {
        return (FileStatusCode)Require.notNull((Object)_CODE_MAP.get(code), (Object)String.valueOf(code));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    static {
        _CODE_MAP = EnumCode.MapFactory.codeMap((Enum[])FileStatusCode.values());
    }
}

