/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.content;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.EnumCode;

public enum IntervalUnit implements EnumCode
{
    NONE(0, "Action Not Repeated"),
    MILLISECONDS(1, "Milliseconds"),
    SECONDS(2, "Seconds"),
    MINUTES(3, "Minutes"),
    HOURS(4, "Hours"),
    DAYS(5, "Days"),
    WEEKS(6, "Weeks"),
    MONTHS(7, "Months"),
    MONTHS_SAME_DOW_FROM_SOM(8, "Months on Same Day of Week from Start of Month"),
    MONTHS_SAME_DOW_FROM_EOM(9, "Months on Same Day of Week from End of Month"),
    SEASONS(10, "Seasons");

    private static final Map<Integer, IntervalUnit> _CODE_MAP;
    private final int _code;
    private final String _title;

    private IntervalUnit(int code, String title) {
        this._code = code;
        this._title = title;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<IntervalUnit> instance(int code) {
        return Optional.ofNullable(_CODE_MAP.get(code));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Nonnull
    @CheckReturnValue
    public String getTitle() {
        return this._title;
    }

    static {
        _CODE_MAP = EnumCode.MapFactory.codeMap((Enum[])IntervalUnit.values());
    }
}

