/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.content;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.object.content.DoubleBitState;

public final class ObjectFlags {
    public static final int BYTES = 1;
    private static final byte _CHATTER_FILTER_MASK = 32;
    private static final byte _COMM_LOST_MASK = 2;
    private static final byte _DISCONTINUITY_MASK = 64;
    private static final byte _DOUBLE_BIT_STATE_MASK = -64;
    private static final byte _DOUBLE_BIT_STATE_SHIFT = 6;
    private static final byte _LOCAL_FORCED_MASK = 16;
    private static final byte _ONLINE_MASK = 1;
    private static final byte _OVER_RANGE_MASK = 32;
    private static final byte _REFERENCE_ERR_MASK = 64;
    private static final byte _REMOTE_FORCED_MASK = 8;
    private static final byte _RESTART_MASK = 2;
    private static final byte _STATE_MASK = -128;
    private byte _flags = 1;

    @CheckReturnValue
    public boolean getChatterFilter() {
        return this._getFlag((byte)32);
    }

    @CheckReturnValue
    public boolean getCommLost() {
        return this._getFlag((byte)2);
    }

    @CheckReturnValue
    public boolean getDiscontinuity() {
        return this._getFlag((byte)64);
    }

    @Nonnull
    @CheckReturnValue
    public DoubleBitState getDoubleBitState() {
        return DoubleBitState.instance((this._flags & 0xFFFFFFC0) >> 6);
    }

    @CheckReturnValue
    public byte getFlags() {
        return this._flags;
    }

    @CheckReturnValue
    public boolean getLocalForced() {
        return this._getFlag((byte)16);
    }

    @CheckReturnValue
    public boolean getOnline() {
        return this._getFlag((byte)1);
    }

    @CheckReturnValue
    public boolean getOverRange() {
        return this._getFlag((byte)32);
    }

    @CheckReturnValue
    public boolean getReferenceErr() {
        return this._getFlag((byte)64);
    }

    @CheckReturnValue
    public boolean getRemoteForced() {
        return this._getFlag((byte)8);
    }

    @CheckReturnValue
    public boolean getRestart() {
        return this._getFlag((byte)2);
    }

    @CheckReturnValue
    public boolean getState() {
        return this._getFlag((byte)-128);
    }

    @CheckReturnValue
    public boolean isDefault() {
        return (this._flags & 0x3F) == 1;
    }

    public void setChatterFilter(boolean chatterFilter) {
        this._setFlag((byte)32, chatterFilter);
    }

    public void setCommLost(boolean commLost) {
        this._setFlag((byte)2, commLost);
    }

    public void setDiscontinuity(boolean discontinuity) {
        this._setFlag((byte)64, discontinuity);
    }

    public void setDoubleBitState(@Nonnull DoubleBitState state) {
        this._flags = (byte)(this._flags & 0xFFFFFFC0);
        this._flags = (byte)(this._flags | state.ordinal() << 6);
    }

    public void setFlags(byte flags) {
        this._flags = flags;
    }

    public void setFlags(@Nonnull Optional<ObjectFlags> objectFlags) {
        this.setFlags(objectFlags.isPresent() ? objectFlags.get().getFlags() : (byte)1);
    }

    public void setLocalForced(boolean localForced) {
        this._setFlag((byte)16, localForced);
    }

    public void setOnline(boolean online) {
        this._setFlag((byte)1, online);
    }

    public void setOverRange(boolean overRange) {
        this._setFlag((byte)32, overRange);
    }

    public void setReferenceErr(boolean referenceErr) {
        this._setFlag((byte)64, referenceErr);
    }

    public void setRemoteForced(boolean remoteForced) {
        this._setFlag((byte)8, remoteForced);
    }

    public void setRestart(boolean restart) {
        this._setFlag((byte)2, restart);
    }

    public void setState(boolean state) {
        this._setFlag((byte)-128, state);
    }

    private boolean _getFlag(byte mask) {
        return (this._flags & mask) != 0;
    }

    private void _setFlag(byte mask, boolean state) {
        this._flags = (byte)(this._flags & ~mask);
        if (state) {
            this._flags = (byte)(this._flags | mask);
        }
    }
}

