/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogInputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G34V0;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G34V1;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G34V2;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G34V3;

public enum AnalogInputReportingDeadbandVariation implements ObjectVariation
{
    ANY(0, "Any", G34V0.class, Optional.empty()),
    INTEGER(1, "32-bit", G34V1.class, Optional.of(DataType.INT32)),
    SHORT(2, "16-bit", G34V2.class, Optional.of(DataType.INT16)),
    FLOAT(3, "Single-precision", G34V3.class, Optional.of(DataType.FLOAT16));

    private static final Map<Integer, AnalogInputReportingDeadbandVariation> _VARIATION_MAP;
    private final int _code;
    private final Optional<DataType> _dataType;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private AnalogInputReportingDeadbandVariation(@Nonnull int code, @Nonnull String title, Class<? extends ObjectInstance> objectClass, Optional<DataType> dataType) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
        this._dataType = dataType;
    }

    @Nonnull
    @CheckReturnValue
    public static AnalogInputReportingDeadbandVariation instance(int variationCode) {
        return (AnalogInputReportingDeadbandVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return this._dataType;
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return AnalogInputsGroup.ANALOG_INPUT_REPORTING_DEADBAND;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])AnalogInputReportingDeadbandVariation.values());
    }
}

