/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogOutputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.G41V0;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.G41V1;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.G41V2;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.G41V3;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.G41V4;

public enum AnalogOutputCommandVariation implements ObjectVariation
{
    ANY(0, "Any", G41V0.class, Optional.empty()),
    INTEGER(1, "32-bit", G41V1.class, Optional.of(DataType.INT32)),
    SHORT(2, "16-bit", G41V2.class, Optional.of(DataType.INT16)),
    FLOAT(3, "Single-precision", G41V3.class, Optional.of(DataType.FLOAT16)),
    DOUBLE(4, "Double-precision", G41V4.class, Optional.of(DataType.FLOAT32));

    private static final Map<Integer, AnalogOutputCommandVariation> _VARIATION_MAP;
    private final int _code;
    private final Optional<DataType> _dataType;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private AnalogOutputCommandVariation(@Nonnull int code, @Nonnull String title, Class<? extends ObjectInstance> objectClass, Optional<DataType> dataType) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
        this._dataType = dataType;
    }

    @Nonnull
    @CheckReturnValue
    public static AnalogOutputCommandVariation instance(int variationCode) {
        return (AnalogOutputCommandVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return this._dataType;
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return AnalogOutputsGroup.ANALOG_OUTPUT_COMMAND;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])AnalogOutputCommandVariation.values());
    }
}

