/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogOutputs;

import java.util.Optional;
import org.rvpf.base.Content;
import org.rvpf.content.DoubleContent;
import org.rvpf.content.FloatContent;
import org.rvpf.content.IntegerContent;
import org.rvpf.content.LongContent;
import org.rvpf.content.ShortContent;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputCommandVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputStatusVariation;

public class AnalogOutputSupport
implements PointType.Support {
    @Override
    public Optional<DataType> getDataType(Content content) {
        DataType dataType = content instanceof ShortContent ? DataType.INT16 : (content instanceof IntegerContent ? DataType.INT32 : (content instanceof FloatContent ? DataType.FLOAT16 : (content instanceof DoubleContent ? DataType.FLOAT32 : (content instanceof LongContent ? DataType.INT32 : null))));
        return Optional.ofNullable(dataType);
    }

    @Override
    public ObjectVariation getInputVariation() {
        return AnalogOutputStatusVariation.ANY;
    }

    @Override
    public Optional<ObjectVariation> getInputVariation(DataType dataType) {
        switch (dataType) {
            case FLOAT16: {
                return Optional.of(AnalogOutputStatusVariation.FLOAT_WITH_FLAG);
            }
            case FLOAT32: {
                return Optional.of(AnalogOutputStatusVariation.DOUBLE_WITH_FLAG);
            }
            case INT16: {
                return Optional.of(AnalogOutputStatusVariation.SHORT_WITH_FLAG);
            }
            case INT32: {
                return Optional.of(AnalogOutputStatusVariation.INTEGER_WITH_FLAG);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<ObjectVariation> getOutputVariation(DataType dataType) {
        switch (dataType) {
            case FLOAT16: {
                return Optional.of(AnalogOutputCommandVariation.FLOAT);
            }
            case FLOAT32: {
                return Optional.of(AnalogOutputCommandVariation.DOUBLE);
            }
            case INT16: {
                return Optional.of(AnalogOutputCommandVariation.SHORT);
            }
            case INT32: {
                return Optional.of(AnalogOutputCommandVariation.INTEGER);
            }
        }
        return Optional.empty();
    }

    @Override
    public PointType getPointType() {
        return PointType.ANALOG_OUTPUT;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

