/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogOutputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputCommandEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputCommandVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputStatusVariation;

public enum AnalogOutputsGroup implements ObjectGroup
{
    ANALOG_OUTPUT_STATUS(40, "Analog Output Status", AnalogOutputStatusVariation.class),
    ANALOG_OUTPUT_COMMAND(41, "Analog Output Command", AnalogOutputCommandVariation.class),
    ANALOG_OUTPUT_EVENT(42, "Analog Output Event", AnalogOutputEventVariation.class),
    ANALOG_OUTPUT_COMMAND_EVENT(43, "Analog Output Command Event", AnalogOutputCommandEventVariation.class);

    private static final Map<Integer, AnalogOutputsGroup> _GROUP_MAP;
    private final int _code;
    private final Class<? extends ObjectVariation> _objectVariationClass;
    private final String _title;

    private AnalogOutputsGroup(@Nonnull int code, String title, Class<? extends ObjectVariation> objectVariationClass) {
        this._code = code;
        this._title = title;
        this._objectVariationClass = objectVariationClass;
    }

    @Nonnull
    @CheckReturnValue
    public static AnalogOutputsGroup instance(int groupCode) {
        return (AnalogOutputsGroup)Require.notNull((Object)_GROUP_MAP.get(groupCode));
    }

    @Override
    public GroupCategory getCategory() {
        return GroupCategory.ANALOG_OUTPUTS;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Class<? extends ObjectVariation> getObjectVariationClass() {
        return this._objectVariationClass;
    }

    @Override
    public Optional<PointType> getPointType() {
        return Optional.of(PointType.ANALOG_OUTPUT);
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _GROUP_MAP = EnumCode.MapFactory.codeMap((Enum[])AnalogOutputsGroup.values());
    }
}

