/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogOutputs;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.ControlStatusCode;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputCommandVariation;

public final class G41V4
extends ObjectInstance.Abstract
implements ObjectInstance.WithValue,
ObjectInstance.WithStatus {
    private byte _status;
    private double _value;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        buffer.putDouble(this._value);
        buffer.put(this._status);
    }

    @Override
    public int getObjectLength() {
        return 9;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return AnalogOutputCommandVariation.DOUBLE;
    }

    @Override
    public ControlStatusCode getStatus() {
        return ControlStatusCode.instance(this._status & 0xFF);
    }

    @Override
    public Serializable getValue() {
        return Double.valueOf(this._value);
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        this._value = buffer.getDouble();
        this._status = buffer.get();
    }

    @Override
    public void setStatus(Optional<ControlStatusCode> status) {
        if (!status.isPresent()) {
            status = Optional.of(ControlStatusCode.SUCCESS);
        }
        this._status = (byte)status.get().getCode();
    }

    @Override
    public void setValue(Serializable value) {
        this._value = ObjectInstance.WithValue.doubleValue(value);
    }
}

