/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogOutputs;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.ControlStatusCode;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputCommandEventVariation;

public class G43V5
extends ObjectInstance.Abstract
implements ObjectInstance.WithValue,
ObjectInstance.WithStatus {
    private byte _status;
    private float _value;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        buffer.put(this._status);
        buffer.putFloat(this._value);
    }

    @Override
    public int getObjectLength() {
        return 5;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return AnalogOutputCommandEventVariation.FLOAT_WITHOUT_TIME;
    }

    @Override
    public final ControlStatusCode getStatus() {
        return ControlStatusCode.instance(this._status & 0xFF);
    }

    @Override
    public final Serializable getValue() {
        return Float.valueOf(this._value);
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        this._status = buffer.get();
        this._value = buffer.getFloat();
    }

    @Override
    public void setStatus(Optional<ControlStatusCode> status) {
        if (!status.isPresent()) {
            status = Optional.of(ControlStatusCode.SUCCESS);
        }
        this._status = (byte)status.get().getCode();
    }

    @Override
    public final void setValue(Serializable value) {
        this._value = ObjectInstance.WithValue.floatValue(value);
    }
}

