/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.BinaryOutputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.BinaryOutputVariation;

public enum BinaryOutputsGroup implements ObjectGroup
{
    BINARY_OUTPUT(10, "Binary Output", BinaryOutputVariation.class),
    BINARY_OUTPUT_EVENT(11, "Binary Output Event", BinaryOutputEventVariation.class);

    private static final Map<Integer, BinaryOutputsGroup> _GROUP_MAP;
    private final int _code;
    private final Class<? extends ObjectVariation> _objectVariationClass;
    private final String _title;

    private BinaryOutputsGroup(@Nonnull int code, String title, Class<? extends ObjectVariation> objectVariationClass) {
        this._code = code;
        this._title = title;
        this._objectVariationClass = objectVariationClass;
    }

    @Nonnull
    @CheckReturnValue
    public static BinaryOutputsGroup instance(int groupCode) {
        return (BinaryOutputsGroup)Require.notNull((Object)_GROUP_MAP.get(groupCode));
    }

    @Override
    public GroupCategory getCategory() {
        return GroupCategory.BINARY_OUTPUTS;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Class<? extends ObjectVariation> getObjectVariationClass() {
        return this._objectVariationClass;
    }

    @Override
    public Optional<PointType> getPointType() {
        return Optional.of(PointType.BINARY_OUTPUT);
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _GROUP_MAP = EnumCode.MapFactory.codeMap((Enum[])BinaryOutputsGroup.values());
    }
}

