/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.counters;

import java.nio.ByteBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.counters.FrozenCounterVariation;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V1;

public final class G21V5
extends G21V1 {
    private long _absoluteTime;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        super.dumpToBuffer(buffer);
        G21V5.putTimeToBuffer(this._absoluteTime, buffer);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime getAbsoluteTime() {
        return DateTime.fromMillis((long)this._absoluteTime);
    }

    @Override
    public int getObjectLength() {
        return super.getObjectLength() + 6;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return FrozenCounterVariation.UNSIGNED_WITH_FLAG_TIME;
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        super.loadFromBuffer(buffer);
        this._absoluteTime = G21V5.getTimeFromBuffer(buffer);
    }

    public void setAbsoluteTime(@Nonnull DateTime absoluteTime) {
        this._absoluteTime = absoluteTime.toMillis();
    }
}

