/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.devices;

import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.devices.InternalIndicationsVariation;

public enum DevicesGroup implements ObjectGroup
{
    INTERNAL_INDICATIONS(80, "Internal Indications", InternalIndicationsVariation.class);

    private static final Map<Integer, DevicesGroup> _GROUP_MAP;
    private final int _code;
    private final Class<? extends ObjectVariation> _objectVariationClass;
    private final String _title;

    private DevicesGroup(@Nonnull int code, String title, Class<? extends ObjectVariation> objectVariationClass) {
        this._code = code;
        this._title = title;
        this._objectVariationClass = objectVariationClass;
    }

    @Nonnull
    @CheckReturnValue
    public static DevicesGroup instance(int group) {
        return (DevicesGroup)Require.notNull((Object)_GROUP_MAP.get(group));
    }

    @Override
    public GroupCategory getCategory() {
        return GroupCategory.DEVICES;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Class<? extends ObjectVariation> getObjectVariationClass() {
        return this._objectVariationClass;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _GROUP_MAP = EnumCode.MapFactory.codeMap((Enum[])DevicesGroup.values());
    }
}

