/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.devices;

import java.nio.ByteBuffer;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.devices.InternalIndicationsVariation;

public final class G80V1
extends ObjectInstance.Abstract
implements ObjectInstance.Packed {
    private short _states;
    private int _valueCount;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        buffer.put((byte)this._states);
        if (this._valueCount > 8) {
            buffer.put((byte)(this._states >> 8));
        }
    }

    @Override
    public int get(int position) {
        return (this._states & 1 << position) != 0 ? 1 : 0;
    }

    @Override
    public int getObjectLength() {
        return this._valueCount > 8 ? 2 : 1;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return InternalIndicationsVariation.PACKED_FORMAT;
    }

    @Override
    public int getValueCount() {
        return this._valueCount;
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        this._states = (short)(buffer.get() & 0xFF);
        if (this._valueCount > 8) {
            this._states = (short)(this._states | (short)(buffer.get() << 8));
        }
    }

    @Override
    public void put(int position, int value) {
        if (position >= this._valueCount) {
            this._valueCount = position + 1;
        }
        short mask = (short)(1 << position);
        this._states = value != 0 ? (short)(this._states | mask) : (short)(this._states & ~mask);
    }

    @Override
    public void setValueCount(int count) {
        this._valueCount = count;
    }
}

