/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.times;

import java.nio.ByteBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.times.G50V1;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimeDateVariation;

public final class G50V2
extends G50V1 {
    private int _interval;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        super.dumpToBuffer(buffer);
        buffer.putInt(this._interval);
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime getInterval() {
        return ElapsedTime.fromMillis((long)((long)this._interval & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public int getObjectLength() {
        return 4;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return TimeDateVariation.ABSOLUTE_TIME_INTERVAL;
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        super.loadFromBuffer(buffer);
        this._interval = buffer.getInt();
    }

    public void setRelativeTime(@Nonnull ElapsedTime relativeTime) {
        this._interval = (int)relativeTime.toMillis();
    }
}

