/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.times;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.times.G50V0;
import org.rvpf.pap.dnp3.object.groupCategory.times.G50V1;
import org.rvpf.pap.dnp3.object.groupCategory.times.G50V2;
import org.rvpf.pap.dnp3.object.groupCategory.times.G50V3;
import org.rvpf.pap.dnp3.object.groupCategory.times.G50V4;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimesGroup;

public enum TimeDateVariation implements ObjectVariation
{
    ANY(0, "Any", G50V0.class),
    ABSOLUTE_TIME(1, "Absolute time", G50V1.class),
    ABSOLUTE_TIME_INTERVAL(2, "Absolute time and interval", G50V2.class),
    ABSOLUTE_TIME_LAST_RECORDED(3, "Absolute time at last recorded time", G50V3.class),
    INDEXED_TIME_INTERVAL(4, "Indexed absolute time and long interval", G50V4.class);

    private static final Map<Integer, TimeDateVariation> _VARIATION_MAP;
    private final int _code;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private TimeDateVariation(@Nonnull int code, String title, Class<? extends ObjectInstance> objectClass) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
    }

    @Nonnull
    @CheckReturnValue
    public static TimeDateVariation instance(int variationCode) {
        return (TimeDateVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return Optional.empty();
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return TimesGroup.TIME_DATE;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])TimeDateVariation.values());
    }
}

