/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.times;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.times.G52V0;
import org.rvpf.pap.dnp3.object.groupCategory.times.G52V1;
import org.rvpf.pap.dnp3.object.groupCategory.times.G52V2;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimesGroup;

public enum TimeDelayVariation implements ObjectVariation
{
    ANY(0, "Any", G52V0.class),
    COARSE(1, "Coarse", G52V1.class),
    FINE(2, "Fine", G52V2.class);

    private static final Map<Integer, TimeDelayVariation> _VARIATION_MAP;
    private final int _code;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private TimeDelayVariation(@Nonnull int code, String title, Class<? extends ObjectInstance> objectClass) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
    }

    @Nonnull
    @CheckReturnValue
    public static TimeDelayVariation instance(int variationCode) {
        return (TimeDelayVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return Optional.empty();
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return TimesGroup.TIME_DELAY;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])TimeDelayVariation.values());
    }
}

