/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.times;

import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimeDateCommonTooVariation;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimeDateVariation;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimeDelayVariation;

public enum TimesGroup implements ObjectGroup
{
    TIME_DATE(50, "Time and Date", TimeDateVariation.class),
    TIME_DATE_COMMON_TOO(51, "Time and Date Common Time-of-Occurrence", TimeDateCommonTooVariation.class),
    TIME_DELAY(52, "Time Delay", TimeDelayVariation.class);

    private static final Map<Integer, TimesGroup> _GROUP_MAP;
    private final int _code;
    private final Class<? extends ObjectVariation> _objectVariationClass;
    private final String _title;

    private TimesGroup(@Nonnull int code, String title, Class<? extends ObjectVariation> objectVariationClass) {
        this._code = code;
        this._title = title;
        this._objectVariationClass = objectVariationClass;
    }

    @Nonnull
    @CheckReturnValue
    public static TimesGroup instance(int groupCode) {
        return (TimesGroup)Require.notNull((Object)_GROUP_MAP.get(groupCode));
    }

    @Override
    public GroupCategory getCategory() {
        return GroupCategory.TIMES;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Class<? extends ObjectVariation> getObjectVariationClass() {
        return this._objectVariationClass;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _GROUP_MAP = EnumCode.MapFactory.codeMap((Enum[])TimesGroup.values());
    }
}

