/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.PAPConnection;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.pap.dnp3.transport.Frame;
import org.rvpf.pap.dnp3.transport.LocalEndPoint;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public abstract class Connection
extends PAPConnection.Abstract
implements ServiceThread.Target {
    private volatile Exception _exception;
    private final LocalEndPoint _localEndPoint;
    private final RemoteEndPoint _remoteEndPoint;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    protected Connection(@Nonnull LocalEndPoint localEndPoint, @Nonnull RemoteEndPoint remoteEndPoint) {
        this._localEndPoint = localEndPoint;
        this._remoteEndPoint = remoteEndPoint;
    }

    public void activate() {
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "Connection " + this);
        if (this._thread.compareAndSet(null, thread)) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    @Override
    public void doClose() throws IOException {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            ConnectionManager connectionManager;
            if (thread != Thread.currentThread()) {
                this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
                Require.ignored((boolean)thread.interruptAndJoin(this.getThisLogger(), 0L));
            }
            if ((connectionManager = this._localEndPoint.getConnectionManager()) != null) {
                connectionManager.onClosedConnection(this);
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Exception> getException() {
        return Optional.ofNullable(this._exception);
    }

    @Nonnull
    @CheckReturnValue
    public LocalEndPoint getLocalEndPoint() {
        return this._localEndPoint;
    }

    @Nonnull
    @CheckReturnValue
    public RemoteEndPoint getRemoteEndPoint() {
        return this._remoteEndPoint;
    }

    @CheckReturnValue
    public boolean isOnMaster() {
        return this._localEndPoint.isOnMaster();
    }

    @CheckReturnValue
    public boolean isOnOutstation() {
        return this._localEndPoint.isOnOutstation();
    }

    public final void receive(@Nonnull ByteBuffer buffer) throws IOException {
        try {
            this.doReceive(buffer);
        }
        catch (Exception exception) {
            this._exception = exception;
            this.close();
            throw exception;
        }
    }

    public void run() throws Exception {
        Frame.Receiver frameReceiver = new Frame.Receiver(this.getRemoteEndPoint());
        try {
            while (true) {
                Frame frame = frameReceiver.receive(this);
                this._remoteEndPoint.onFrameReceived(frame);
            }
        }
        catch (ClosedChannelException frame) {
            frameReceiver.close();
        }
        catch (Exception exception) {
            try {
                this._exception = exception;
                throw exception;
            }
            catch (Throwable throwable) {
                frameReceiver.close();
                throw throwable;
            }
        }
    }

    public final void send(@Nonnull ByteBuffer buffer) throws IOException {
        try {
            this.doSend(buffer);
        }
        catch (Exception exception) {
            this._exception = exception;
            this.close();
            throw exception;
        }
    }

    protected abstract void doReceive(@Nonnull ByteBuffer var1) throws IOException;

    protected abstract void doSend(@Nonnull ByteBuffer var1) throws IOException;
}

