/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.dnp3.DNP3Context;
import org.rvpf.pap.dnp3.DNP3MasterProxy;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3Proxy;
import org.rvpf.pap.dnp3.transport.ApplicationMessage;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.AssociationListener;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.DataLinkLayer;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.Frame;
import org.rvpf.pap.dnp3.transport.LocalEndPoint;
import org.rvpf.pap.dnp3.transport.LogicalDevice;
import org.rvpf.pap.dnp3.transport.ReceivedFragmentListener;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;
import org.rvpf.pap.dnp3.transport.SerialConnection;
import org.rvpf.pap.dnp3.transport.TCPConnection;
import org.rvpf.pap.dnp3.transport.TCPSocketListener;
import org.rvpf.pap.dnp3.transport.UDPConnection;
import org.rvpf.pap.dnp3.transport.UDPDatagramListener;

public final class ConnectionManager {
    private static final Logger _LOGGER = Logger.getInstance(ConnectionManager.class);
    private volatile AssociationListener.Manager _associationListenerManager = new AssociationListener.Manager();
    private final Map<RemoteEndPoint, Connection> _connectionByEndPoint = Collections.synchronizedMap(new IdentityHashMap());
    private volatile PAPConnectionListener _connectionListener;
    private final DNP3Context _context;
    private final LocalEndPoint _localEndPoint;
    private final Map<Short, LogicalDevice> _logicalDeviceByAddress = new HashMap<Short, LogicalDevice>();
    private final Map<String, LogicalDevice> _logicalDeviceByName = new HashMap<String, LogicalDevice>();
    private final ReceivedFragmentListener.Manager _receivedFragmentListenerManager = new ReceivedFragmentListener.Manager();
    private final Map<DNP3Proxy, RemoteEndPoint> _remoteEndPointByProxy = new HashMap<DNP3Proxy, RemoteEndPoint>();
    private final Map<InetAddress, RemoteEndPoint> _remoteEndPointByTCPAddress = new HashMap<InetAddress, RemoteEndPoint>();
    private final Map<InetSocketAddress, RemoteEndPoint> _remoteEndPointByTCPSocketAddress = new HashMap<InetSocketAddress, RemoteEndPoint>();
    private final Map<InetAddress, RemoteEndPoint> _remoteEndPointByUDPAddress = new HashMap<InetAddress, RemoteEndPoint>();
    private final Map<InetSocketAddress, RemoteEndPoint> _remoteEndPointByUDPSocketAddress = new HashMap<InetSocketAddress, RemoteEndPoint>();
    private final Map<RemoteEndPoint, RemoteEndPoint> _remoteEndPoints = new HashMap<RemoteEndPoint, RemoteEndPoint>();
    private boolean _setUpCompleted;
    private TCPSocketListener _tcpListener;
    private UDPDatagramListener _udpListener;

    public ConnectionManager(@Nonnull DNP3Context context) {
        this._context = (DNP3Context)Require.notNull((Object)context);
        this._localEndPoint = new LocalEndPoint(this);
    }

    @CheckReturnValue
    public boolean addAssociationListener(@Nonnull AssociationListener associationListener) {
        return this._associationListenerManager.addListener(associationListener);
    }

    @CheckReturnValue
    public boolean addReceivedFragmentListener(@Nonnull ReceivedFragmentListener receivedFragmentListener) {
        return this._receivedFragmentListenerManager.addListener(receivedFragmentListener);
    }

    @Nullable
    @CheckReturnValue
    public Association connect(@Nonnull DNP3Proxy proxy, short localAddress, short remoteAddress) {
        Short logicalDeviceAddress;
        Require.notNull((Object)this._connectionListener);
        RemoteEndPoint remoteEndPoint = this._remoteEndPointByProxy.get(proxy);
        if (remoteEndPoint == null) {
            remoteEndPoint = new RemoteEndPoint(this, proxy);
            this._remoteEndPointByProxy.put(proxy, remoteEndPoint);
            _LOGGER.debug((Messages.Entry)DNP3Messages.NEW_CONNECTION, new Object[]{proxy.getName().orElse(null)});
        }
        if (!this._logicalDeviceByAddress.containsKey(logicalDeviceAddress = Short.valueOf(localAddress))) {
            LogicalDevice logicalDevice = new LogicalDevice("", logicalDeviceAddress);
            this._logicalDeviceByAddress.put(logicalDeviceAddress, logicalDevice);
            _LOGGER.debug((Messages.Entry)DNP3Messages.REGISTERED_LOCAL_ADDRESS, new Object[]{logicalDevice});
            logicalDevice.activate(this);
        }
        Association association = remoteEndPoint.getAssociation(localAddress, remoteAddress);
        DataLinkLayer dataLinkLayer = association.getDataLinkLayer();
        try {
            return dataLinkLayer.isLinkActive(remoteEndPoint.getReplyTimeout()) ? association : null;
        }
        catch (IOException exception) {
            _LOGGER.trace((Throwable)exception, (Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
            return null;
        }
    }

    public void disconnect() {
        for (RemoteEndPoint remoteEndPoint : new ArrayList<RemoteEndPoint>(this._connectionByEndPoint.keySet())) {
            this.disconnect(remoteEndPoint.getRemoteProxy());
        }
    }

    public void disconnect(@Nonnull DNP3Proxy proxy) {
        Optional<Object> connectionException;
        Connection connection;
        RemoteEndPoint remoteEndPoint = this._remoteEndPointByProxy.get(proxy);
        Connection connection2 = connection = remoteEndPoint != null ? this._connectionByEndPoint.remove(remoteEndPoint) : null;
        if (connection != null) {
            connectionException = connection.getException();
            connection.close();
        } else {
            connectionException = Optional.empty();
        }
        if (remoteEndPoint != null) {
            this._remoteEndPointByProxy.remove(proxy);
            remoteEndPoint.close();
            if (connectionException.isPresent()) {
                _LOGGER.debug((Messages.Entry)DNP3Messages.LOST_CONNECTION_, new Object[]{proxy.getName().orElse(null), ((Exception)connectionException.get()).getMessage()});
            } else {
                _LOGGER.debug((Messages.Entry)DNP3Messages.LOST_CONNECTION, new Object[]{proxy.getName().orElse(null)});
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    public LocalEndPoint getLocalEndPoint() {
        return this._localEndPoint;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<LogicalDevice> getLogicalDevice(@Nonnull Short address) {
        return Optional.ofNullable(this._logicalDeviceByAddress.get(address));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<LogicalDevice> getLogicalDevice(@Nonnull String name) {
        return Optional.ofNullable(this._logicalDeviceByName.get(name));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<RemoteEndPoint> getRemoteEndPoint(@Nonnull DNP3Proxy proxy) {
        return Optional.ofNullable(this._remoteEndPointByProxy.get(proxy));
    }

    @Nonnull
    @CheckReturnValue
    public Traces getTraces() {
        return this._context.getTraces();
    }

    public void registerLogicalDevices(@Nonnull Map<Short, LogicalDevice> logicalDevicesByAddress) {
        this._logicalDeviceByAddress.putAll(logicalDevicesByAddress);
        this._logicalDeviceByAddress.values().stream().forEach(logicalDevice -> {
            _LOGGER.debug((Messages.Entry)DNP3Messages.REGISTERED_LOCAL_ADDRESS, new Object[]{logicalDevice});
            String name = logicalDevice.getName();
            if (!name.isEmpty()) {
                this._logicalDeviceByName.put(name, (LogicalDevice)logicalDevice);
            }
        });
    }

    @CheckReturnValue
    public boolean removeAssociationListener(@Nonnull AssociationListener associationListener) {
        return this._associationListenerManager.removeListener(associationListener);
    }

    @CheckReturnValue
    public boolean removeReceivedFragmentListener(@Nonnull ReceivedFragmentListener receivedFragmentListener) {
        return this._receivedFragmentListenerManager.removeListener(receivedFragmentListener);
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull KeyedValues listenProperties) {
        Optional tcpListenAddress = listenProperties.getString("tcp.listen.address");
        Optional tcpListenPort = listenProperties.getInteger("tcp.listen.port", Optional.empty());
        if (tcpListenAddress.isPresent() || tcpListenPort.isPresent()) {
            Optional<InetSocketAddress> tcpListenSocketAddress = ConnectionManager._listenSocketAddress(tcpListenAddress.orElse(null), tcpListenPort.orElse(null));
            if (!tcpListenSocketAddress.isPresent()) {
                return false;
            }
            this._tcpListener = new TCPSocketListener(tcpListenSocketAddress.get(), this);
        }
        Optional udpListenAddress = listenProperties.getString("udp.listen.address");
        Optional udpListenPort = listenProperties.getInteger("udp.listen.port", Optional.empty());
        if (udpListenAddress.isPresent() || udpListenPort.isPresent()) {
            Optional<InetSocketAddress> udpListenSocketAddress = ConnectionManager._listenSocketAddress(udpListenAddress.orElse(null), udpListenPort.orElse(null));
            if (!udpListenSocketAddress.isPresent()) {
                return false;
            }
            this._udpListener = new UDPDatagramListener(udpListenSocketAddress.get(), this);
        }
        this._setUpCompleted = true;
        return true;
    }

    public void startListening(@Nonnull PAPConnectionListener connectionListener) throws IOException {
        if (!this._setUpCompleted) {
            Require.success((boolean)this.setUp((KeyedValues)KeyedGroups.MISSING_KEYED_GROUP));
        }
        this._connectionListener = connectionListener;
        this._logicalDeviceByAddress.values().stream().forEach(logicalDevice -> logicalDevice.activate(this));
        if (this._tcpListener != null) {
            this._tcpListener.start();
        }
        if (this._udpListener != null) {
            this._udpListener.start();
        }
    }

    public void stopListening() throws IOException {
        if (this._setUpCompleted && this._connectionListener != null) {
            this._logicalDeviceByAddress.values().stream().forEach(logicalDevice -> logicalDevice.deactivate());
            if (this._udpListener != null) {
                this._udpListener.stop();
            }
            if (this._tcpListener != null) {
                this._tcpListener.stop();
            }
            this.disconnect();
            this._receivedFragmentListenerManager.clear();
            this._associationListenerManager.clear();
        }
        this._connectionListener = null;
    }

    public void tearDown() {
        if (this._connectionListener != null) {
            try {
                this.stopListening();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._localEndPoint.close();
        this.getTraces().tearDown();
    }

    @Nullable
    @CheckReturnValue
    Connection getConnection(@Nonnull RemoteEndPoint remoteEndPoint) {
        String serialPortName;
        Connection connection = this._connectionByEndPoint.get(remoteEndPoint);
        if (connection != null) {
            if (!connection.isClosed()) {
                return connection;
            }
            this._connectionByEndPoint.remove(remoteEndPoint);
            connection = null;
        } else {
            RemoteEndPoint knownEndPoint = this._remoteEndPoints.get(remoteEndPoint);
            if (knownEndPoint == null) {
                this._remoteEndPoints.put(remoteEndPoint, remoteEndPoint);
            } else if (remoteEndPoint != knownEndPoint) {
                throw new IllegalArgumentException("Duplicate remote end point");
            }
        }
        int connectTimeout = remoteEndPoint.getConnectTimeout();
        for (InetSocketAddress socketAddress : remoteEndPoint.getTCPSocketAddresses()) {
            SocketChannel socketChannel = null;
            _LOGGER.debug((Messages.Entry)DNP3Messages.TRYING_CONNECTION_TO, new Object[]{socketAddress});
            try {
                socketChannel = SocketChannel.open();
                socketChannel.socket().connect(socketAddress, connectTimeout);
            }
            catch (IOException exception1) {
                if (socketChannel == null) continue;
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            connection = new TCPConnection(this._localEndPoint, remoteEndPoint, socketChannel);
            this._remoteEndPointByTCPSocketAddress.put(socketAddress, remoteEndPoint);
            this._remoteEndPointByTCPAddress.put(socketAddress.getAddress(), remoteEndPoint);
            break;
        }
        if (connection == null && this._udpListener != null) {
            SocketAddress localAddress;
            DatagramChannel datagramChannel = this._udpListener.getChannel();
            try {
                localAddress = datagramChannel.getLocalAddress();
            }
            catch (IOException exception) {
                throw new InternalError(exception);
            }
            Iterator<InetSocketAddress> iterator = remoteEndPoint.getUDPSocketAddresses().iterator();
            if (iterator.hasNext()) {
                InetSocketAddress socketAddress = iterator.next();
                _LOGGER.debug((Messages.Entry)DNP3Messages.TRYING_CONNECTION_FROM_TO, new Object[]{localAddress, socketAddress});
                connection = new UDPConnection(this._localEndPoint, remoteEndPoint, datagramChannel, socketAddress);
                this._remoteEndPointByUDPSocketAddress.put(socketAddress, remoteEndPoint);
                this._remoteEndPointByUDPAddress.put(socketAddress.getAddress(), remoteEndPoint);
            }
        }
        if (connection == null && !(serialPortName = remoteEndPoint.getSerialPortName()).isEmpty()) {
            _LOGGER.debug((Messages.Entry)DNP3Messages.TRYING_CONNECTION_THRU, new Object[]{serialPortName});
            connection = new SerialConnection(this._localEndPoint, remoteEndPoint, serialPortName, remoteEndPoint.getSerialPortSpeed());
            try {
                ((SerialConnection)connection).purge();
            }
            catch (IOException exception1) {
                connection.close();
                connection = null;
            }
        }
        if (connection != null) {
            this._activateConnection(connection);
            _LOGGER.debug((Messages.Entry)DNP3Messages.CONNECTION_OPENED, new Object[]{connection});
        } else {
            _LOGGER.warn((Messages.Entry)DNP3Messages.CONNECTION_FAILED, new Object[]{remoteEndPoint.getRemoteProxyName().orElse(null)});
        }
        return connection;
    }

    @CheckReturnValue
    boolean isOnMaster() {
        return this._context.isClientContext();
    }

    @CheckReturnValue
    boolean isOnOutstation() {
        return this._context.isServerContext();
    }

    void onClosedConnection(@Nonnull Connection connection) {
        PAPConnectionListener connectionListener = this._connectionListener;
        if (connectionListener != null) {
            Require.ignored((boolean)connectionListener.onLostConnection(connection.getRemoteEndPoint().getRemoteProxy(), connection.getException()));
        }
    }

    void onDatagramReceived(@Nonnull InetSocketAddress sourceAddress, @Nonnull ByteBuffer buffer) {
        RemoteEndPoint remoteEndPoint = this._remoteEndPointByUDPSocketAddress.get(sourceAddress);
        if (this.isOnMaster()) {
            Connection connection = this._connectionByEndPoint.get(remoteEndPoint);
            if (connection instanceof UDPConnection) {
                ((UDPConnection)connection).onDatagramReceived(buffer);
            }
        } else {
            Connection connection;
            if (remoteEndPoint == null && (remoteEndPoint = this._remoteEndPointByUDPAddress.get(sourceAddress.getAddress())) == null) {
                DNP3MasterProxy remoteProxy = new DNP3MasterProxy(this._context, "Unknown-UDP-" + this._remoteEndPointByUDPSocketAddress.size());
                remoteProxy.setMaxFragmentSize(2048);
                remoteEndPoint = new RemoteEndPoint(this, remoteProxy);
                this._remoteEndPointByProxy.put(remoteProxy, remoteEndPoint);
                this._remoteEndPointByUDPSocketAddress.put(sourceAddress, remoteEndPoint);
            }
            if ((connection = this._connectionByEndPoint.get(remoteEndPoint)) != null && !(connection instanceof UDPConnection)) {
                connection.close();
                connection = null;
            }
            if (connection == null) {
                connection = new UDPConnection(this._localEndPoint, remoteEndPoint, this._udpListener.getChannel(), sourceAddress);
                this._activateConnection(connection);
                _LOGGER.debug((Messages.Entry)DNP3Messages.MASTER_CONNECTION_ACCEPTED, new Object[]{remoteEndPoint.getRemoteProxyName().orElse(null), sourceAddress});
            }
            ((UDPConnection)connection).onDatagramReceived(buffer);
        }
    }

    @CheckReturnValue
    boolean onFrameReceived(Frame frame, RemoteEndPoint remoteEndPoint) throws IOException {
        Frame.Header frameHeader = frame.getHeader();
        LogicalDevice logicalDevice = this._logicalDeviceByAddress.get(frameHeader.getDestination());
        if (logicalDevice == null) {
            return false;
        }
        return logicalDevice.onFrameReceived(remoteEndPoint, frameHeader.getSource());
    }

    void onNewAssociation(@Nonnull Association association) throws IOException {
        this._associationListenerManager.onNewAssociation(association);
    }

    @CheckReturnValue
    boolean onReceivedFragment(@Nonnull Association association, @Nonnull Fragment receivedFragment) throws IOException {
        return this._receivedFragmentListenerManager.onReceivedFragment(receivedFragment);
    }

    void onSocketAccepted(@Nonnull SocketChannel socketChannel) {
        Connection connection;
        InetSocketAddress remoteSocketAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        RemoteEndPoint remoteEndPoint = this._remoteEndPointByTCPSocketAddress.get(remoteSocketAddress);
        if (remoteEndPoint == null) {
            remoteEndPoint = this._remoteEndPointByTCPAddress.get(remoteSocketAddress.getAddress());
        }
        if (remoteEndPoint == null && this.isOnOutstation()) {
            DNP3MasterProxy remoteProxy = new DNP3MasterProxy(this._context, "Unknown-TCP-" + this._remoteEndPointByTCPSocketAddress.size());
            remoteProxy.setMaxFragmentSize(2048);
            remoteEndPoint = new RemoteEndPoint(this, remoteProxy);
            this._remoteEndPointByProxy.put(remoteProxy, remoteEndPoint);
            this._remoteEndPointByTCPSocketAddress.put(remoteSocketAddress, remoteEndPoint);
        }
        if (remoteEndPoint != null && (connection = this._connectionByEndPoint.get(remoteEndPoint)) == null) {
            connection = new TCPConnection(this._localEndPoint, remoteEndPoint, socketChannel);
            this._activateConnection(connection);
            _LOGGER.debug((Messages.Entry)(this.isOnMaster() ? DNP3Messages.OUTSTATION_CONNECTION_ACCEPTED : DNP3Messages.MASTER_CONNECTION_ACCEPTED), new Object[]{remoteEndPoint.getRemoteProxyName().orElse(null), remoteSocketAddress});
        }
    }

    void receiveMessages(@Nonnull Association association) throws IOException {
        while (true) {
            new ApplicationMessage(association, Optional.empty(), this.isOnOutstation()).receive();
        }
    }

    private static Optional<InetSocketAddress> _listenSocketAddress(String listenAddress, Integer listenPort) {
        InetAddress localAddress = Inet.getLocalAddress(Optional.ofNullable(listenAddress));
        if (localAddress == null) {
            return Optional.empty();
        }
        int port = listenPort != null ? listenPort : 20000;
        return Optional.of(new InetSocketAddress(localAddress, port));
    }

    private void _activateConnection(Connection connection) {
        RemoteEndPoint remoteEndPoint = connection.getRemoteEndPoint();
        this._connectionByEndPoint.put(remoteEndPoint, connection);
        connection.activate();
        Require.ignored((boolean)this._connectionListener.onNewConnection(remoteEndPoint.getRemoteProxy()));
    }
}

