/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.transport.ConnectionManager;

public abstract class EndPoint {
    private volatile ConnectionManager _connectionManager;
    private volatile Logger _logger;

    protected EndPoint(@Nonnull ConnectionManager connectionManager) {
        this._connectionManager = connectionManager;
    }

    @Nonnull
    @CheckReturnValue
    public ConnectionManager getConnectionManager() {
        ConnectionManager connectionManager = this._connectionManager;
        Require.notNull((Object)connectionManager);
        return connectionManager;
    }

    @CheckReturnValue
    public boolean isOnMaster() {
        return this.getConnectionManager().isOnMaster();
    }

    @CheckReturnValue
    public boolean isOnOutstation() {
        return this.getConnectionManager().isOnOutstation();
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        Logger logger = this._logger;
        if (logger == null) {
            this._logger = logger = Logger.getInstance(this.getClass());
        }
        return logger;
    }

    void close() {
        this._connectionManager = null;
    }
}

