/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;

public enum FunctionCode implements EnumCode
{
    CONFIRM(0, "Confirm", false),
    READ(1, "Read", false),
    WRITE(2, "Write", true),
    SELECT(3, "Select", true),
    OPERATE(4, "Operate", true),
    DIRECT_OPERATE(5, "Direct Operate", true),
    DIRECT_OPERATE_NR(6, "Direct Operate -- No Response", true),
    IMMED_FREEZE(7, "Immediate Freeze", false),
    IMMED_FREEZE_NR(8, "Immediate Freeza -- No Response", false),
    FREEZE_CLEAR(9, "Freeze and Clear", false),
    FREEZE_CLEAR_NR(10, "Freeze and Clear -- No Response", false),
    FREEZE_AT_TIME(11, "Freeze at Time", false),
    FREEZE_AT_TIME_NR(12, "Freeze at Time -- No Response", false),
    COLD_RESTART(13, "Cold Restart", false),
    WARM_RESTART(14, "Warm Restart", false),
    INITIALIZE_DATA(15, "Initializa Data", false),
    INITIALIZE_APPL(16, "Initialize Application", false),
    START_APPL(17, "Start Application", false),
    STOP_APPL(18, "Stop Application", false),
    SAVE_CONFIG(19, "Save Configuration", false),
    ENABLE_UNSOLICITED(20, "Enable Unsolicited Response", false),
    DISABLE_UNSOLICITED(21, "Disable Unsolicited Response", false),
    ASSIGN_CLASS(22, "Assign Class", false),
    DELAY_MEASURE(23, "Delay Measure", false),
    RECORD_CURRENT_TIME(24, "Record Current Time", false),
    OPEN_FILE(25, "Open File", false),
    CLOSE_FILE(26, "Close File", false),
    DELETE_FILE(27, "Delete File", false),
    GET_FILE_INFO(28, "Get File Information", false),
    AUTHENTICATE_FILE(29, "Authenticate File", false),
    ABORT_FILE(30, "Abort File", false),
    ACTIVATE_CONFIG(31, "Activate Configuration", false),
    AUTHENTICATE_REQ(32, "Authentication Request", false),
    AUTH_REQ_NO_ACK(33, "Authentication Request -- No Acknowledgment", false),
    RESPONSE(129, "Solicited Response", true),
    UNSOLICITED_RESPONSE(130, "Unsolicited Response", true),
    AUTHENTICATE_RESP(131, "Authentication Response", false);

    private static final Map<Integer, FunctionCode> _CODE_MAP;
    private final int _code;
    private final String _name;
    private final boolean _needsValues;

    private FunctionCode(int code, String name, boolean needsValues) {
        this._code = code;
        this._name = name;
        this._needsValues = needsValues;
    }

    @Nonnull
    @CheckReturnValue
    public static FunctionCode instance(int code) throws DNP3ProtocolException {
        FunctionCode functionCode = _CODE_MAP.get(code);
        if (functionCode == null) {
            throw new DNP3ProtocolException(DNP3Messages.UNKNOWN_FUNCTION_CODE, String.valueOf(Math.abs(code)));
        }
        return functionCode;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Nonnull
    @CheckReturnValue
    public String getName() {
        return this._name;
    }

    @CheckReturnValue
    public boolean needsValues() {
        return this._needsValues;
    }

    static {
        _CODE_MAP = EnumCode.MapFactory.codeMap((Enum[])FunctionCode.values());
    }
}

