/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;

public final class OutstationMasterAssociation
extends Association {
    private boolean _firstValidRequestAccepted;
    private byte _latestAcceptedRequestSequence;
    private Fragment _latestSolicitedResponseFragment;
    private Fragment _latestUnsolicitedResponseFragment;

    public OutstationMasterAssociation(short localDeviceAddress, short remoteDeviceAddress, @Nonnull RemoteEndPoint remoteEndPoint) {
        super(localDeviceAddress, remoteDeviceAddress, remoteEndPoint);
    }

    @CheckReturnValue
    public byte getLatestAcceptedRequestSequence() {
        return this._latestAcceptedRequestSequence;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Fragment> getLatestSolicitedResponseFragment() {
        return Optional.ofNullable(this._latestSolicitedResponseFragment);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Fragment> getLatestUnsolicitedResponseFragment() {
        return Optional.ofNullable(this._latestUnsolicitedResponseFragment);
    }

    @CheckReturnValue
    public boolean isFirstValidRequestAccepted() {
        return this._firstValidRequestAccepted;
    }

    @Override
    public boolean isWithOutstation() {
        return false;
    }

    public void setFirstValidRequestAccepted(boolean firstValidRequestAccepted) {
        this._firstValidRequestAccepted = firstValidRequestAccepted;
    }

    public void setLatestAcceptedRequestSequence(byte latestAcceptedRequestSequence) {
        this._latestAcceptedRequestSequence = latestAcceptedRequestSequence;
    }

    public void setLatestSolicitedResponseFragment(@Nonnull Fragment latestSolicitedResponseFragment) {
        this._latestSolicitedResponseFragment = latestSolicitedResponseFragment;
    }

    public void setLatestUnsolicitedResponseFragment(@Nonnull Fragment latestUnsolicitedResponseFragment) {
        this._latestUnsolicitedResponseFragment = latestUnsolicitedResponseFragment;
    }
}

