/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPReadTransaction;
import org.rvpf.pap.PAPTransaction;
import org.rvpf.pap.dnp3.DNP3OutstationProxy;
import org.rvpf.pap.dnp3.transport.Transaction;

public final class ReadTransaction
extends Transaction {
    private final Collection<Request> _requests = new LinkedList<Request>();
    private final Collection<Response> _responses = new LinkedList<Response>();

    ReadTransaction(@Nonnull DNP3OutstationProxy outstationProxy) {
        super(outstationProxy);
    }

    @Nonnull
    Request addRequest(@Nonnull Point point) {
        Request request = new Request(point);
        this._requests.add(request);
        return request;
    }

    void addResponse(@Nonnull Request request, @Nonnull Optional<PointValue> pointValue) {
        this._responses.add(new Response(request, pointValue));
    }

    @Nonnull
    @CheckReturnValue
    Response[] commit() throws ServiceNotAvailableException {
        try {
            Response[] responseArray = this._responses.toArray(new Response[this._responses.size()]);
            return responseArray;
        }
        finally {
            this.rollback();
        }
    }

    @Nonnull
    @CheckReturnValue
    Collection<Request> getRequests() {
        return this._requests;
    }

    @CheckReturnValue
    boolean isEmpty() {
        return this._requests.isEmpty();
    }

    void rollback() {
        this._requests.clear();
        this._responses.clear();
    }

    public final class Response
    extends Transaction.Response
    implements PAPReadTransaction.Response {
        final Optional<PointValue> _pointValue;

        Response(@Nonnull Request request, Optional<PointValue> pointValue) {
            super(request);
            this._pointValue = pointValue;
        }

        @Override
        public Optional<PointValue> getPointValue() {
            return this._pointValue;
        }

        @Override
        public boolean isSuccess() {
            return this._pointValue.isPresent() && !ReadTransaction.this.getException().isPresent();
        }
    }

    public final class Request
    extends Transaction.Request
    implements PAPReadTransaction.Request {
        private final Point _point;

        Request(Point point) {
            super(ReadTransaction.this);
            this._point = (Point)Require.notNull((Object)point);
        }

        @Override
        public Point getPoint() {
            return this._point;
        }

        @Override
        public Optional<? extends PAPTransaction.Response> getResponse() throws InterruptedException {
            return Optional.empty();
        }

        @Override
        public boolean waitForResponse() throws InterruptedException {
            return false;
        }
    }
}

