/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.SerialPortWrapper;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.LocalEndPoint;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;

public final class SerialConnection
extends Connection {
    private final SerialPortWrapper _serialPort;

    public SerialConnection(@Nonnull LocalEndPoint localEndPoint, @Nonnull RemoteEndPoint remoteEndPoint, @Nonnull String portName, int portSpeed) {
        super(localEndPoint, remoteEndPoint);
        this._serialPort = SerialPortWrapper.newBuilder().setPortName(portName).setPortDataBits(8).setPortParity("NONE").setPortControl(true).setPortSpeed(portSpeed).build();
    }

    @Override
    public void doClose() throws IOException {
        this._serialPort.close();
        super.doClose();
    }

    public void purge() throws IOException {
        this._serialPort.open();
        this._serialPort.purge();
    }

    public String toString() {
        return this._serialPort.getPortName();
    }

    @Override
    protected void doReceive(ByteBuffer buffer) throws IOException {
        Require.success((boolean)buffer.hasRemaining());
        byte[] bytes = this._serialPort.read(buffer.remaining());
        if (bytes == null) {
            throw new ClosedChannelException();
        }
        buffer.put(bytes);
    }

    @Override
    protected void doSend(ByteBuffer buffer) throws IOException {
        Require.success((boolean)buffer.hasRemaining());
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this._serialPort.write(bytes);
    }

    @Override
    protected String getName() {
        return this._serialPort.getPortName();
    }
}

