/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.LocalEndPoint;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;

public final class TCPConnection
extends Connection {
    private final InetSocketAddress _localAddress;
    private final InetSocketAddress _remoteAddress;
    private final SocketChannel _socketChannel;

    public TCPConnection(@Nonnull LocalEndPoint localEndPoint, @Nonnull RemoteEndPoint remoteEndPoint, @Nonnull SocketChannel channel) {
        super(localEndPoint, remoteEndPoint);
        this._socketChannel = channel;
        try {
            this._localAddress = (InetSocketAddress)this._socketChannel.getLocalAddress();
            this._remoteAddress = (InetSocketAddress)this._socketChannel.getRemoteAddress();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void doClose() throws IOException {
        this._socketChannel.close();
        super.doClose();
    }

    public String toString() {
        return this._localAddress.toString() + " > " + this._remoteAddress.toString();
    }

    @Override
    protected void doReceive(ByteBuffer buffer) throws IOException {
        try {
            this._socketChannel.read(buffer);
        }
        catch (AsynchronousCloseException exception) {
            throw new ClosedChannelException();
        }
    }

    @Override
    protected void doSend(ByteBuffer buffer) throws IOException {
        try {
            this._socketChannel.write(buffer);
        }
        catch (AsynchronousCloseException exception) {
            throw new ClosedChannelException();
        }
    }

    @Override
    protected String getName() {
        return this._localAddress.toString();
    }
}

