/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.LocalEndPoint;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;

public final class UDPConnection
extends Connection {
    private ByteBuffer _datagram;
    private final DatagramChannel _datagramChannel;
    private final BlockingQueue<byte[]> _datagrams = new LinkedBlockingQueue<byte[]>();
    private final InetSocketAddress _localAddress;
    private final Object _receiveMutex = new Object();
    private final InetSocketAddress _remoteAddress;

    public UDPConnection(@Nonnull LocalEndPoint localEndPoint, @Nonnull RemoteEndPoint remoteEndPoint, @Nonnull DatagramChannel datagramChannel, @Nonnull InetSocketAddress remoteAddress) {
        super(localEndPoint, remoteEndPoint);
        this._datagramChannel = datagramChannel;
        try {
            this._localAddress = (InetSocketAddress)this._datagramChannel.getLocalAddress();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this._remoteAddress = remoteAddress;
    }

    @Override
    public void doClose() throws IOException {
        super.doClose();
        this._datagramChannel.close();
    }

    public void onDatagramReceived(@Nonnull ByteBuffer buffer) {
        byte[] datagram = new byte[buffer.remaining()];
        if (datagram.length > 0) {
            buffer.get(datagram);
            this._datagrams.add(datagram);
        }
    }

    public String toString() {
        return this._localAddress.toString() + " > " + this._remoteAddress.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReceive(ByteBuffer buffer) throws IOException {
        Object object = this._receiveMutex;
        synchronized (object) {
            if (this._datagram == null) {
                try {
                    this._datagram = ByteBuffer.wrap(this._datagrams.take());
                }
                catch (InterruptedException exception) {
                    throw new ClosedChannelException();
                }
            }
            do {
                buffer.put(this._datagram.get());
                if (this._datagram.hasRemaining()) continue;
                this._datagram = null;
                break;
            } while (buffer.hasRemaining());
        }
    }

    @Override
    protected void doSend(ByteBuffer buffer) throws IOException {
        try {
            this._datagramChannel.send(buffer, this._remoteAddress);
        }
        catch (AsynchronousCloseException exception) {
            throw new ClosedChannelException();
        }
    }

    @Override
    protected String getName() {
        return this._localAddress.toString();
    }
}

